<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for etkinMaddeDVO StructType
 * @subpackage Structs
 */
class EtkinMaddeDVO extends AbstractStructBase
{
    /**
     * The kodu
     * @var string
     */
    public $kodu;
    /**
     * The adi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $adi;
    /**
     * The icerikMiktari
     * @var string
     */
    public $icerikMiktari;
    /**
     * The formu
     * @var string
     */
    public $formu;
    /**
     * Constructor method for etkinMaddeDVO
     * @uses EtkinMaddeDVO::setKodu()
     * @uses EtkinMaddeDVO::setAdi()
     * @uses EtkinMaddeDVO::setIcerikMiktari()
     * @uses EtkinMaddeDVO::setFormu()
     * @param string $kodu
     * @param string $adi
     * @param string $icerikMiktari
     * @param string $formu
     */
    public function __construct($kodu = null, $adi = null, $icerikMiktari = null, $formu = null)
    {
        $this
            ->setKodu($kodu)
            ->setAdi($adi)
            ->setIcerikMiktari($icerikMiktari)
            ->setFormu($formu);
    }
    /**
     * Get kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->kodu;
    }
    /**
     * Set kodu value
     * @param string $kodu
     * @return \StructType\EtkinMaddeDVO
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodu)), __LINE__);
        }
        $this->kodu = $kodu;
        return $this;
    }
    /**
     * Get adi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdi()
    {
        return isset($this->adi) ? $this->adi : null;
    }
    /**
     * Set adi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adi
     * @return \StructType\EtkinMaddeDVO
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adi)), __LINE__);
        }
        if (is_null($adi) || (is_array($adi) && empty($adi))) {
            unset($this->adi);
        } else {
            $this->adi = $adi;
        }
        return $this;
    }
    /**
     * Get icerikMiktari value
     * @return string|null
     */
    public function getIcerikMiktari()
    {
        return $this->icerikMiktari;
    }
    /**
     * Set icerikMiktari value
     * @param string $icerikMiktari
     * @return \StructType\EtkinMaddeDVO
     */
    public function setIcerikMiktari($icerikMiktari = null)
    {
        // validation for constraint: string
        if (!is_null($icerikMiktari) && !is_string($icerikMiktari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icerikMiktari)), __LINE__);
        }
        $this->icerikMiktari = $icerikMiktari;
        return $this;
    }
    /**
     * Get formu value
     * @return string|null
     */
    public function getFormu()
    {
        return $this->formu;
    }
    /**
     * Set formu value
     * @param string $formu
     * @return \StructType\EtkinMaddeDVO
     */
    public function setFormu($formu = null)
    {
        // validation for constraint: string
        if (!is_null($formu) && !is_string($formu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formu)), __LINE__);
        }
        $this->formu = $formu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EtkinMaddeDVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
