<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rapor ServiceType
 * @subpackage Services
 */
class Rapor extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named raporTeshisListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RaporTeshisListesiSorgula $parameters
     * @return \StructType\RaporTeshisListesiSorgulaResponse|bool
     */
    public function raporTeshisListesiSorgula(\StructType\RaporTeshisListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->raporTeshisListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RaporTeshisListesiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
