<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pasif ServiceType
 * @subpackage Services
 */
class Pasif extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pasifIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PasifIlacListesiSorgula $parameters
     * @return \StructType\PasifIlacListesiSorgulaResponse|bool
     */
    public function pasifIlacListesiSorgula(\StructType\PasifIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pasifIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pasifYurtdisiIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PasifYurtdisiIlacListesiSorgula $parameters
     * @return \StructType\PasifYurtdisiIlacListesiSorgulaResponse|bool
     */
    public function pasifYurtdisiIlacListesiSorgula(\StructType\PasifYurtdisiIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pasifYurtdisiIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PasifIlacListesiSorgulaResponse|\StructType\PasifYurtdisiIlacListesiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
