<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kirmizi ServiceType
 * @subpackage Services
 */
class Kirmizi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kirmiziReceteIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KirmiziReceteIlacListesiSorgula $parameters
     * @return \StructType\KirmiziReceteIlacListesiSorgulaResponse|bool
     */
    public function kirmiziReceteIlacListesiSorgula(\StructType\KirmiziReceteIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->kirmiziReceteIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * kirmiziReceteYurtdisiIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KirmiziReceteYurtdisiIlacListesiSorgula $parameters
     * @return \StructType\KirmiziReceteYurtdisiIlacListesiSorgulaResponse|bool
     */
    public function kirmiziReceteYurtdisiIlacListesiSorgula(\StructType\KirmiziReceteYurtdisiIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->kirmiziReceteYurtdisiIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KirmiziReceteIlacListesiSorgulaResponse|\StructType\KirmiziReceteYurtdisiIlacListesiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
