<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Etkin ServiceType
 * @subpackage Services
 */
class Etkin extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named etkinMaddeSutListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EtkinMaddeSutListesiSorgula $parameters
     * @return \StructType\EtkinMaddeSutListesiSorgulaResponse|bool
     */
    public function etkinMaddeSutListesiSorgula(\StructType\EtkinMaddeSutListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->etkinMaddeSutListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named etkinMaddeListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EtkinMaddeListesiSorgula $parameters
     * @return \StructType\EtkinMaddeListesiSorgulaResponse|bool
     */
    public function etkinMaddeListesiSorgula(\StructType\EtkinMaddeListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->etkinMaddeListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EtkinMaddeListesiSorgulaResponse|\StructType\EtkinMaddeSutListesiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
