<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Aktif ServiceType
 * @subpackage Services
 */
class Aktif extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named aktifIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AktifIlacListesiSorgula $parameters
     * @return \StructType\AktifIlacListesiSorgulaResponse|bool
     */
    public function aktifIlacListesiSorgula(\StructType\AktifIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->aktifIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named aktifYurtdisiIlacListesiSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AktifYurtdisiIlacListesiSorgula $parameters
     * @return \StructType\AktifYurtdisiIlacListesiSorgulaResponse|bool
     */
    public function aktifYurtdisiIlacListesiSorgula(\StructType\AktifYurtdisiIlacListesiSorgula $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->aktifYurtdisiIlacListesiSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AktifIlacListesiSorgulaResponse|\StructType\AktifYurtdisiIlacListesiSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
