<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ereceteIlacDVO StructType
 * @subpackage Structs
 */
class EreceteIlacDVO extends AbstractStructBase
{
    /**
     * The adet
     * @var int
     */
    public $adet;
    /**
     * The barkod
     * @var int
     */
    public $barkod;
    /**
     * The ilacAdi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ilacAdi;
    /**
     * The kullanimDoz1
     * @var int
     */
    public $kullanimDoz1;
    /**
     * The kullanimPeriyotBirimi
     * @var int
     */
    public $kullanimPeriyotBirimi;
    /**
     * The kullanimSekli
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $kullanimSekli;
    /**
     * The ereceteIlacAciklamaListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EreceteIlacAciklamaDVO[]
     */
    public $ereceteIlacAciklamaListesi;
    /**
     * The kullanimDoz2
     * @var float
     */
    public $kullanimDoz2;
    /**
     * The kullanimPeriyot
     * @var int
     */
    public $kullanimPeriyot;
    /**
     * The geriOdemeKapsaminda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geriOdemeKapsaminda;
    /**
     * Constructor method for ereceteIlacDVO
     * @uses EreceteIlacDVO::setAdet()
     * @uses EreceteIlacDVO::setBarkod()
     * @uses EreceteIlacDVO::setIlacAdi()
     * @uses EreceteIlacDVO::setKullanimDoz1()
     * @uses EreceteIlacDVO::setKullanimPeriyotBirimi()
     * @uses EreceteIlacDVO::setKullanimSekli()
     * @uses EreceteIlacDVO::setEreceteIlacAciklamaListesi()
     * @uses EreceteIlacDVO::setKullanimDoz2()
     * @uses EreceteIlacDVO::setKullanimPeriyot()
     * @uses EreceteIlacDVO::setGeriOdemeKapsaminda()
     * @param int $adet
     * @param int $barkod
     * @param string $ilacAdi
     * @param int $kullanimDoz1
     * @param int $kullanimPeriyotBirimi
     * @param int $kullanimSekli
     * @param \StructType\EreceteIlacAciklamaDVO[] $ereceteIlacAciklamaListesi
     * @param float $kullanimDoz2
     * @param int $kullanimPeriyot
     * @param string $geriOdemeKapsaminda
     */
    public function __construct($adet = null, $barkod = null, $ilacAdi = null, $kullanimDoz1 = null, $kullanimPeriyotBirimi = null, $kullanimSekli = null, array $ereceteIlacAciklamaListesi = array(), $kullanimDoz2 = null, $kullanimPeriyot = null, $geriOdemeKapsaminda = null)
    {
        $this
            ->setAdet($adet)
            ->setBarkod($barkod)
            ->setIlacAdi($ilacAdi)
            ->setKullanimDoz1($kullanimDoz1)
            ->setKullanimPeriyotBirimi($kullanimPeriyotBirimi)
            ->setKullanimSekli($kullanimSekli)
            ->setEreceteIlacAciklamaListesi($ereceteIlacAciklamaListesi)
            ->setKullanimDoz2($kullanimDoz2)
            ->setKullanimPeriyot($kullanimPeriyot)
            ->setGeriOdemeKapsaminda($geriOdemeKapsaminda);
    }
    /**
     * Get adet value
     * @return int|null
     */
    public function getAdet()
    {
        return $this->adet;
    }
    /**
     * Set adet value
     * @param int $adet
     * @return \StructType\EreceteIlacDVO
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !is_numeric($adet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adet)), __LINE__);
        }
        $this->adet = $adet;
        return $this;
    }
    /**
     * Get barkod value
     * @return int|null
     */
    public function getBarkod()
    {
        return $this->barkod;
    }
    /**
     * Set barkod value
     * @param int $barkod
     * @return \StructType\EreceteIlacDVO
     */
    public function setBarkod($barkod = null)
    {
        // validation for constraint: int
        if (!is_null($barkod) && !is_numeric($barkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($barkod)), __LINE__);
        }
        $this->barkod = $barkod;
        return $this;
    }
    /**
     * Get ilacAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIlacAdi()
    {
        return isset($this->ilacAdi) ? $this->ilacAdi : null;
    }
    /**
     * Set ilacAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ilacAdi
     * @return \StructType\EreceteIlacDVO
     */
    public function setIlacAdi($ilacAdi = null)
    {
        // validation for constraint: string
        if (!is_null($ilacAdi) && !is_string($ilacAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ilacAdi)), __LINE__);
        }
        if (is_null($ilacAdi) || (is_array($ilacAdi) && empty($ilacAdi))) {
            unset($this->ilacAdi);
        } else {
            $this->ilacAdi = $ilacAdi;
        }
        return $this;
    }
    /**
     * Get kullanimDoz1 value
     * @return int|null
     */
    public function getKullanimDoz1()
    {
        return $this->kullanimDoz1;
    }
    /**
     * Set kullanimDoz1 value
     * @param int $kullanimDoz1
     * @return \StructType\EreceteIlacDVO
     */
    public function setKullanimDoz1($kullanimDoz1 = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimDoz1) && !is_numeric($kullanimDoz1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kullanimDoz1)), __LINE__);
        }
        $this->kullanimDoz1 = $kullanimDoz1;
        return $this;
    }
    /**
     * Get kullanimPeriyotBirimi value
     * @return int|null
     */
    public function getKullanimPeriyotBirimi()
    {
        return $this->kullanimPeriyotBirimi;
    }
    /**
     * Set kullanimPeriyotBirimi value
     * @param int $kullanimPeriyotBirimi
     * @return \StructType\EreceteIlacDVO
     */
    public function setKullanimPeriyotBirimi($kullanimPeriyotBirimi = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimPeriyotBirimi) && !is_numeric($kullanimPeriyotBirimi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kullanimPeriyotBirimi)), __LINE__);
        }
        $this->kullanimPeriyotBirimi = $kullanimPeriyotBirimi;
        return $this;
    }
    /**
     * Get kullanimSekli value
     * @return int|null
     */
    public function getKullanimSekli()
    {
        return $this->kullanimSekli;
    }
    /**
     * Set kullanimSekli value
     * @param int $kullanimSekli
     * @return \StructType\EreceteIlacDVO
     */
    public function setKullanimSekli($kullanimSekli = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimSekli) && !is_numeric($kullanimSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kullanimSekli)), __LINE__);
        }
        $this->kullanimSekli = $kullanimSekli;
        return $this;
    }
    /**
     * Get ereceteIlacAciklamaListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EreceteIlacAciklamaDVO[]|null
     */
    public function getEreceteIlacAciklamaListesi()
    {
        return isset($this->ereceteIlacAciklamaListesi) ? $this->ereceteIlacAciklamaListesi : null;
    }
    /**
     * Set ereceteIlacAciklamaListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteIlacAciklamaDVO[] $ereceteIlacAciklamaListesi
     * @return \StructType\EreceteIlacDVO
     */
    public function setEreceteIlacAciklamaListesi(array $ereceteIlacAciklamaListesi = array())
    {
        foreach ($ereceteIlacAciklamaListesi as $ereceteIlacDVOEreceteIlacAciklamaListesiItem) {
            // validation for constraint: itemType
            if (!$ereceteIlacDVOEreceteIlacAciklamaListesiItem instanceof \StructType\EreceteIlacAciklamaDVO) {
                throw new \InvalidArgumentException(sprintf('The ereceteIlacAciklamaListesi property can only contain items of \StructType\EreceteIlacAciklamaDVO, "%s" given', is_object($ereceteIlacDVOEreceteIlacAciklamaListesiItem) ? get_class($ereceteIlacDVOEreceteIlacAciklamaListesiItem) : gettype($ereceteIlacDVOEreceteIlacAciklamaListesiItem)), __LINE__);
            }
        }
        if (is_null($ereceteIlacAciklamaListesi) || (is_array($ereceteIlacAciklamaListesi) && empty($ereceteIlacAciklamaListesi))) {
            unset($this->ereceteIlacAciklamaListesi);
        } else {
            $this->ereceteIlacAciklamaListesi = $ereceteIlacAciklamaListesi;
        }
        return $this;
    }
    /**
     * Add item to ereceteIlacAciklamaListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteIlacAciklamaDVO $item
     * @return \StructType\EreceteIlacDVO
     */
    public function addToEreceteIlacAciklamaListesi(\StructType\EreceteIlacAciklamaDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EreceteIlacAciklamaDVO) {
            throw new \InvalidArgumentException(sprintf('The ereceteIlacAciklamaListesi property can only contain items of \StructType\EreceteIlacAciklamaDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ereceteIlacAciklamaListesi[] = $item;
        return $this;
    }
    /**
     * Get kullanimDoz2 value
     * @return float|null
     */
    public function getKullanimDoz2()
    {
        return $this->kullanimDoz2;
    }
    /**
     * Set kullanimDoz2 value
     * @param float $kullanimDoz2
     * @return \StructType\EreceteIlacDVO
     */
    public function setKullanimDoz2($kullanimDoz2 = null)
    {
        $this->kullanimDoz2 = $kullanimDoz2;
        return $this;
    }
    /**
     * Get kullanimPeriyot value
     * @return int|null
     */
    public function getKullanimPeriyot()
    {
        return $this->kullanimPeriyot;
    }
    /**
     * Set kullanimPeriyot value
     * @param int $kullanimPeriyot
     * @return \StructType\EreceteIlacDVO
     */
    public function setKullanimPeriyot($kullanimPeriyot = null)
    {
        // validation for constraint: int
        if (!is_null($kullanimPeriyot) && !is_numeric($kullanimPeriyot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kullanimPeriyot)), __LINE__);
        }
        $this->kullanimPeriyot = $kullanimPeriyot;
        return $this;
    }
    /**
     * Get geriOdemeKapsaminda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeriOdemeKapsaminda()
    {
        return isset($this->geriOdemeKapsaminda) ? $this->geriOdemeKapsaminda : null;
    }
    /**
     * Set geriOdemeKapsaminda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geriOdemeKapsaminda
     * @return \StructType\EreceteIlacDVO
     */
    public function setGeriOdemeKapsaminda($geriOdemeKapsaminda = null)
    {
        // validation for constraint: string
        if (!is_null($geriOdemeKapsaminda) && !is_string($geriOdemeKapsaminda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geriOdemeKapsaminda)), __LINE__);
        }
        if (is_null($geriOdemeKapsaminda) || (is_array($geriOdemeKapsaminda) && empty($geriOdemeKapsaminda))) {
            unset($this->geriOdemeKapsaminda);
        } else {
            $this->geriOdemeKapsaminda = $geriOdemeKapsaminda;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EreceteIlacDVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
