<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ereceteDVO StructType
 * @subpackage Structs
 */
class EreceteDVO extends AbstractStructBase
{
    /**
     * The protokolNo
     * @var string
     */
    public $protokolNo;
    /**
     * The provizyonTipi
     * @var int
     */
    public $provizyonTipi;
    /**
     * The receteAltTuru
     * @var int
     */
    public $receteAltTuru;
    /**
     * The receteTarihi
     * @var string
     */
    public $receteTarihi;
    /**
     * The receteTuru
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $receteTuru;
    /**
     * The takipNo
     * @var string
     */
    public $takipNo;
    /**
     * The tcKimlikNo
     * @var int
     */
    public $tcKimlikNo;
    /**
     * The tesisKodu
     * @var int
     */
    public $tesisKodu;
    /**
     * The seriNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $seriNo;
    /**
     * The doktorBransKodu
     * @var int
     */
    public $doktorBransKodu;
    /**
     * The doktorSertifikaKodu
     * @var int
     */
    public $doktorSertifikaKodu;
    /**
     * The kisiDVO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KisiDVO
     */
    public $kisiDVO;
    /**
     * The ereceteNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ereceteNo;
    /**
     * The ereceteIlacListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\EreceteIlacDVO[]
     */
    public $ereceteIlacListesi;
    /**
     * The ereceteTaniListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\EreceteTaniDVO[]
     */
    public $ereceteTaniListesi;
    /**
     * The ereceteAciklamaListesi
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EreceteAciklamaDVO[]
     */
    public $ereceteAciklamaListesi;
    /**
     * The doktorAdi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $doktorAdi;
    /**
     * The doktorSoyadi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $doktorSoyadi;
    /**
     * The doktorTcKimlikNo
     * @var int
     */
    public $doktorTcKimlikNo;
    /**
     * Constructor method for ereceteDVO
     * @uses EreceteDVO::setProtokolNo()
     * @uses EreceteDVO::setProvizyonTipi()
     * @uses EreceteDVO::setReceteAltTuru()
     * @uses EreceteDVO::setReceteTarihi()
     * @uses EreceteDVO::setReceteTuru()
     * @uses EreceteDVO::setTakipNo()
     * @uses EreceteDVO::setTcKimlikNo()
     * @uses EreceteDVO::setTesisKodu()
     * @uses EreceteDVO::setSeriNo()
     * @uses EreceteDVO::setDoktorBransKodu()
     * @uses EreceteDVO::setDoktorSertifikaKodu()
     * @uses EreceteDVO::setKisiDVO()
     * @uses EreceteDVO::setEreceteNo()
     * @uses EreceteDVO::setEreceteIlacListesi()
     * @uses EreceteDVO::setEreceteTaniListesi()
     * @uses EreceteDVO::setEreceteAciklamaListesi()
     * @uses EreceteDVO::setDoktorAdi()
     * @uses EreceteDVO::setDoktorSoyadi()
     * @uses EreceteDVO::setDoktorTcKimlikNo()
     * @param string $protokolNo
     * @param int $provizyonTipi
     * @param int $receteAltTuru
     * @param string $receteTarihi
     * @param int $receteTuru
     * @param string $takipNo
     * @param int $tcKimlikNo
     * @param int $tesisKodu
     * @param string $seriNo
     * @param int $doktorBransKodu
     * @param int $doktorSertifikaKodu
     * @param \StructType\KisiDVO $kisiDVO
     * @param string $ereceteNo
     * @param \StructType\EreceteIlacDVO[] $ereceteIlacListesi
     * @param \StructType\EreceteTaniDVO[] $ereceteTaniListesi
     * @param \StructType\EreceteAciklamaDVO[] $ereceteAciklamaListesi
     * @param string $doktorAdi
     * @param string $doktorSoyadi
     * @param int $doktorTcKimlikNo
     */
    public function __construct($protokolNo = null, $provizyonTipi = null, $receteAltTuru = null, $receteTarihi = null, $receteTuru = null, $takipNo = null, $tcKimlikNo = null, $tesisKodu = null, $seriNo = null, $doktorBransKodu = null, $doktorSertifikaKodu = null, \StructType\KisiDVO $kisiDVO = null, $ereceteNo = null, array $ereceteIlacListesi = array(), array $ereceteTaniListesi = array(), array $ereceteAciklamaListesi = array(), $doktorAdi = null, $doktorSoyadi = null, $doktorTcKimlikNo = null)
    {
        $this
            ->setProtokolNo($protokolNo)
            ->setProvizyonTipi($provizyonTipi)
            ->setReceteAltTuru($receteAltTuru)
            ->setReceteTarihi($receteTarihi)
            ->setReceteTuru($receteTuru)
            ->setTakipNo($takipNo)
            ->setTcKimlikNo($tcKimlikNo)
            ->setTesisKodu($tesisKodu)
            ->setSeriNo($seriNo)
            ->setDoktorBransKodu($doktorBransKodu)
            ->setDoktorSertifikaKodu($doktorSertifikaKodu)
            ->setKisiDVO($kisiDVO)
            ->setEreceteNo($ereceteNo)
            ->setEreceteIlacListesi($ereceteIlacListesi)
            ->setEreceteTaniListesi($ereceteTaniListesi)
            ->setEreceteAciklamaListesi($ereceteAciklamaListesi)
            ->setDoktorAdi($doktorAdi)
            ->setDoktorSoyadi($doktorSoyadi)
            ->setDoktorTcKimlikNo($doktorTcKimlikNo);
    }
    /**
     * Get protokolNo value
     * @return string|null
     */
    public function getProtokolNo()
    {
        return $this->protokolNo;
    }
    /**
     * Set protokolNo value
     * @param string $protokolNo
     * @return \StructType\EreceteDVO
     */
    public function setProtokolNo($protokolNo = null)
    {
        // validation for constraint: string
        if (!is_null($protokolNo) && !is_string($protokolNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protokolNo)), __LINE__);
        }
        $this->protokolNo = $protokolNo;
        return $this;
    }
    /**
     * Get provizyonTipi value
     * @return int|null
     */
    public function getProvizyonTipi()
    {
        return $this->provizyonTipi;
    }
    /**
     * Set provizyonTipi value
     * @param int $provizyonTipi
     * @return \StructType\EreceteDVO
     */
    public function setProvizyonTipi($provizyonTipi = null)
    {
        // validation for constraint: int
        if (!is_null($provizyonTipi) && !is_numeric($provizyonTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($provizyonTipi)), __LINE__);
        }
        $this->provizyonTipi = $provizyonTipi;
        return $this;
    }
    /**
     * Get receteAltTuru value
     * @return int|null
     */
    public function getReceteAltTuru()
    {
        return $this->receteAltTuru;
    }
    /**
     * Set receteAltTuru value
     * @param int $receteAltTuru
     * @return \StructType\EreceteDVO
     */
    public function setReceteAltTuru($receteAltTuru = null)
    {
        // validation for constraint: int
        if (!is_null($receteAltTuru) && !is_numeric($receteAltTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receteAltTuru)), __LINE__);
        }
        $this->receteAltTuru = $receteAltTuru;
        return $this;
    }
    /**
     * Get receteTarihi value
     * @return string|null
     */
    public function getReceteTarihi()
    {
        return $this->receteTarihi;
    }
    /**
     * Set receteTarihi value
     * @param string $receteTarihi
     * @return \StructType\EreceteDVO
     */
    public function setReceteTarihi($receteTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($receteTarihi) && !is_string($receteTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receteTarihi)), __LINE__);
        }
        $this->receteTarihi = $receteTarihi;
        return $this;
    }
    /**
     * Get receteTuru value
     * @return int|null
     */
    public function getReceteTuru()
    {
        return $this->receteTuru;
    }
    /**
     * Set receteTuru value
     * @param int $receteTuru
     * @return \StructType\EreceteDVO
     */
    public function setReceteTuru($receteTuru = null)
    {
        // validation for constraint: int
        if (!is_null($receteTuru) && !is_numeric($receteTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receteTuru)), __LINE__);
        }
        $this->receteTuru = $receteTuru;
        return $this;
    }
    /**
     * Get takipNo value
     * @return string|null
     */
    public function getTakipNo()
    {
        return $this->takipNo;
    }
    /**
     * Set takipNo value
     * @param string $takipNo
     * @return \StructType\EreceteDVO
     */
    public function setTakipNo($takipNo = null)
    {
        // validation for constraint: string
        if (!is_null($takipNo) && !is_string($takipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($takipNo)), __LINE__);
        }
        $this->takipNo = $takipNo;
        return $this;
    }
    /**
     * Get tcKimlikNo value
     * @return int|null
     */
    public function getTcKimlikNo()
    {
        return $this->tcKimlikNo;
    }
    /**
     * Set tcKimlikNo value
     * @param int $tcKimlikNo
     * @return \StructType\EreceteDVO
     */
    public function setTcKimlikNo($tcKimlikNo = null)
    {
        // validation for constraint: int
        if (!is_null($tcKimlikNo) && !is_numeric($tcKimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tcKimlikNo)), __LINE__);
        }
        $this->tcKimlikNo = $tcKimlikNo;
        return $this;
    }
    /**
     * Get tesisKodu value
     * @return int|null
     */
    public function getTesisKodu()
    {
        return $this->tesisKodu;
    }
    /**
     * Set tesisKodu value
     * @param int $tesisKodu
     * @return \StructType\EreceteDVO
     */
    public function setTesisKodu($tesisKodu = null)
    {
        // validation for constraint: int
        if (!is_null($tesisKodu) && !is_numeric($tesisKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tesisKodu)), __LINE__);
        }
        $this->tesisKodu = $tesisKodu;
        return $this;
    }
    /**
     * Get seriNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriNo()
    {
        return isset($this->seriNo) ? $this->seriNo : null;
    }
    /**
     * Set seriNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriNo
     * @return \StructType\EreceteDVO
     */
    public function setSeriNo($seriNo = null)
    {
        // validation for constraint: string
        if (!is_null($seriNo) && !is_string($seriNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seriNo)), __LINE__);
        }
        if (is_null($seriNo) || (is_array($seriNo) && empty($seriNo))) {
            unset($this->seriNo);
        } else {
            $this->seriNo = $seriNo;
        }
        return $this;
    }
    /**
     * Get doktorBransKodu value
     * @return int|null
     */
    public function getDoktorBransKodu()
    {
        return $this->doktorBransKodu;
    }
    /**
     * Set doktorBransKodu value
     * @param int $doktorBransKodu
     * @return \StructType\EreceteDVO
     */
    public function setDoktorBransKodu($doktorBransKodu = null)
    {
        // validation for constraint: int
        if (!is_null($doktorBransKodu) && !is_numeric($doktorBransKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($doktorBransKodu)), __LINE__);
        }
        $this->doktorBransKodu = $doktorBransKodu;
        return $this;
    }
    /**
     * Get doktorSertifikaKodu value
     * @return int|null
     */
    public function getDoktorSertifikaKodu()
    {
        return $this->doktorSertifikaKodu;
    }
    /**
     * Set doktorSertifikaKodu value
     * @param int $doktorSertifikaKodu
     * @return \StructType\EreceteDVO
     */
    public function setDoktorSertifikaKodu($doktorSertifikaKodu = null)
    {
        // validation for constraint: int
        if (!is_null($doktorSertifikaKodu) && !is_numeric($doktorSertifikaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($doktorSertifikaKodu)), __LINE__);
        }
        $this->doktorSertifikaKodu = $doktorSertifikaKodu;
        return $this;
    }
    /**
     * Get kisiDVO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KisiDVO|null
     */
    public function getKisiDVO()
    {
        return isset($this->kisiDVO) ? $this->kisiDVO : null;
    }
    /**
     * Set kisiDVO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KisiDVO $kisiDVO
     * @return \StructType\EreceteDVO
     */
    public function setKisiDVO(\StructType\KisiDVO $kisiDVO = null)
    {
        if (is_null($kisiDVO) || (is_array($kisiDVO) && empty($kisiDVO))) {
            unset($this->kisiDVO);
        } else {
            $this->kisiDVO = $kisiDVO;
        }
        return $this;
    }
    /**
     * Get ereceteNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEreceteNo()
    {
        return isset($this->ereceteNo) ? $this->ereceteNo : null;
    }
    /**
     * Set ereceteNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ereceteNo
     * @return \StructType\EreceteDVO
     */
    public function setEreceteNo($ereceteNo = null)
    {
        // validation for constraint: string
        if (!is_null($ereceteNo) && !is_string($ereceteNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ereceteNo)), __LINE__);
        }
        if (is_null($ereceteNo) || (is_array($ereceteNo) && empty($ereceteNo))) {
            unset($this->ereceteNo);
        } else {
            $this->ereceteNo = $ereceteNo;
        }
        return $this;
    }
    /**
     * Get ereceteIlacListesi value
     * @return \StructType\EreceteIlacDVO[]|null
     */
    public function getEreceteIlacListesi()
    {
        return $this->ereceteIlacListesi;
    }
    /**
     * Set ereceteIlacListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteIlacDVO[] $ereceteIlacListesi
     * @return \StructType\EreceteDVO
     */
    public function setEreceteIlacListesi(array $ereceteIlacListesi = array())
    {
        foreach ($ereceteIlacListesi as $ereceteDVOEreceteIlacListesiItem) {
            // validation for constraint: itemType
            if (!$ereceteDVOEreceteIlacListesiItem instanceof \StructType\EreceteIlacDVO) {
                throw new \InvalidArgumentException(sprintf('The ereceteIlacListesi property can only contain items of \StructType\EreceteIlacDVO, "%s" given', is_object($ereceteDVOEreceteIlacListesiItem) ? get_class($ereceteDVOEreceteIlacListesiItem) : gettype($ereceteDVOEreceteIlacListesiItem)), __LINE__);
            }
        }
        $this->ereceteIlacListesi = $ereceteIlacListesi;
        return $this;
    }
    /**
     * Add item to ereceteIlacListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteIlacDVO $item
     * @return \StructType\EreceteDVO
     */
    public function addToEreceteIlacListesi(\StructType\EreceteIlacDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EreceteIlacDVO) {
            throw new \InvalidArgumentException(sprintf('The ereceteIlacListesi property can only contain items of \StructType\EreceteIlacDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ereceteIlacListesi[] = $item;
        return $this;
    }
    /**
     * Get ereceteTaniListesi value
     * @return \StructType\EreceteTaniDVO[]|null
     */
    public function getEreceteTaniListesi()
    {
        return $this->ereceteTaniListesi;
    }
    /**
     * Set ereceteTaniListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteTaniDVO[] $ereceteTaniListesi
     * @return \StructType\EreceteDVO
     */
    public function setEreceteTaniListesi(array $ereceteTaniListesi = array())
    {
        foreach ($ereceteTaniListesi as $ereceteDVOEreceteTaniListesiItem) {
            // validation for constraint: itemType
            if (!$ereceteDVOEreceteTaniListesiItem instanceof \StructType\EreceteTaniDVO) {
                throw new \InvalidArgumentException(sprintf('The ereceteTaniListesi property can only contain items of \StructType\EreceteTaniDVO, "%s" given', is_object($ereceteDVOEreceteTaniListesiItem) ? get_class($ereceteDVOEreceteTaniListesiItem) : gettype($ereceteDVOEreceteTaniListesiItem)), __LINE__);
            }
        }
        $this->ereceteTaniListesi = $ereceteTaniListesi;
        return $this;
    }
    /**
     * Add item to ereceteTaniListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteTaniDVO $item
     * @return \StructType\EreceteDVO
     */
    public function addToEreceteTaniListesi(\StructType\EreceteTaniDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EreceteTaniDVO) {
            throw new \InvalidArgumentException(sprintf('The ereceteTaniListesi property can only contain items of \StructType\EreceteTaniDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ereceteTaniListesi[] = $item;
        return $this;
    }
    /**
     * Get ereceteAciklamaListesi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EreceteAciklamaDVO[]|null
     */
    public function getEreceteAciklamaListesi()
    {
        return isset($this->ereceteAciklamaListesi) ? $this->ereceteAciklamaListesi : null;
    }
    /**
     * Set ereceteAciklamaListesi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteAciklamaDVO[] $ereceteAciklamaListesi
     * @return \StructType\EreceteDVO
     */
    public function setEreceteAciklamaListesi(array $ereceteAciklamaListesi = array())
    {
        foreach ($ereceteAciklamaListesi as $ereceteDVOEreceteAciklamaListesiItem) {
            // validation for constraint: itemType
            if (!$ereceteDVOEreceteAciklamaListesiItem instanceof \StructType\EreceteAciklamaDVO) {
                throw new \InvalidArgumentException(sprintf('The ereceteAciklamaListesi property can only contain items of \StructType\EreceteAciklamaDVO, "%s" given', is_object($ereceteDVOEreceteAciklamaListesiItem) ? get_class($ereceteDVOEreceteAciklamaListesiItem) : gettype($ereceteDVOEreceteAciklamaListesiItem)), __LINE__);
            }
        }
        if (is_null($ereceteAciklamaListesi) || (is_array($ereceteAciklamaListesi) && empty($ereceteAciklamaListesi))) {
            unset($this->ereceteAciklamaListesi);
        } else {
            $this->ereceteAciklamaListesi = $ereceteAciklamaListesi;
        }
        return $this;
    }
    /**
     * Add item to ereceteAciklamaListesi value
     * @throws \InvalidArgumentException
     * @param \StructType\EreceteAciklamaDVO $item
     * @return \StructType\EreceteDVO
     */
    public function addToEreceteAciklamaListesi(\StructType\EreceteAciklamaDVO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EreceteAciklamaDVO) {
            throw new \InvalidArgumentException(sprintf('The ereceteAciklamaListesi property can only contain items of \StructType\EreceteAciklamaDVO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ereceteAciklamaListesi[] = $item;
        return $this;
    }
    /**
     * Get doktorAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoktorAdi()
    {
        return isset($this->doktorAdi) ? $this->doktorAdi : null;
    }
    /**
     * Set doktorAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doktorAdi
     * @return \StructType\EreceteDVO
     */
    public function setDoktorAdi($doktorAdi = null)
    {
        // validation for constraint: string
        if (!is_null($doktorAdi) && !is_string($doktorAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doktorAdi)), __LINE__);
        }
        if (is_null($doktorAdi) || (is_array($doktorAdi) && empty($doktorAdi))) {
            unset($this->doktorAdi);
        } else {
            $this->doktorAdi = $doktorAdi;
        }
        return $this;
    }
    /**
     * Get doktorSoyadi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoktorSoyadi()
    {
        return isset($this->doktorSoyadi) ? $this->doktorSoyadi : null;
    }
    /**
     * Set doktorSoyadi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doktorSoyadi
     * @return \StructType\EreceteDVO
     */
    public function setDoktorSoyadi($doktorSoyadi = null)
    {
        // validation for constraint: string
        if (!is_null($doktorSoyadi) && !is_string($doktorSoyadi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doktorSoyadi)), __LINE__);
        }
        if (is_null($doktorSoyadi) || (is_array($doktorSoyadi) && empty($doktorSoyadi))) {
            unset($this->doktorSoyadi);
        } else {
            $this->doktorSoyadi = $doktorSoyadi;
        }
        return $this;
    }
    /**
     * Get doktorTcKimlikNo value
     * @return int|null
     */
    public function getDoktorTcKimlikNo()
    {
        return $this->doktorTcKimlikNo;
    }
    /**
     * Set doktorTcKimlikNo value
     * @param int $doktorTcKimlikNo
     * @return \StructType\EreceteDVO
     */
    public function setDoktorTcKimlikNo($doktorTcKimlikNo = null)
    {
        // validation for constraint: int
        if (!is_null($doktorTcKimlikNo) && !is_numeric($doktorTcKimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($doktorTcKimlikNo)), __LINE__);
        }
        $this->doktorTcKimlikNo = $doktorTcKimlikNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EreceteDVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
