<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Imzali ServiceType
 * @subpackage Services
 */
class Imzali extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named imzaliEreceteSorgu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteSorgu $parameters
     * @return \StructType\ImzaliEreceteSorguResponse|bool
     */
    public function imzaliEreceteSorgu(\StructType\ImzaliEreceteSorgu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteSorgu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteListeSorgu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteListeSorgu $parameters
     * @return \StructType\ImzaliEreceteListeSorguResponse|bool
     */
    public function imzaliEreceteListeSorgu(\StructType\ImzaliEreceteListeSorgu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteListeSorgu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteGiris
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteGiris $parameters
     * @return \StructType\ImzaliEreceteGirisResponse|bool
     */
    public function imzaliEreceteGiris(\StructType\ImzaliEreceteGiris $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteGiris($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteSil $parameters
     * @return \StructType\ImzaliEreceteSilResponse|bool
     */
    public function imzaliEreceteSil(\StructType\ImzaliEreceteSil $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteOnay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteOnay $parameters
     * @return \StructType\ImzaliEreceteOnayResponse|bool
     */
    public function imzaliEreceteOnay(\StructType\ImzaliEreceteOnay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteOnay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteOnayIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteOnayIptal $parameters
     * @return \StructType\ImzaliEreceteOnayIptalResponse|bool
     */
    public function imzaliEreceteOnayIptal(\StructType\ImzaliEreceteOnayIptal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteOnayIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteTaniEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteTaniEkle $parameters
     * @return \StructType\ImzaliEreceteTaniEkleResponse|bool
     */
    public function imzaliEreceteTaniEkle(\StructType\ImzaliEreceteTaniEkle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteTaniEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteAciklamaEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteAciklamaEkle $parameters
     * @return \StructType\ImzaliEreceteAciklamaEkleResponse|bool
     */
    public function imzaliEreceteAciklamaEkle(\StructType\ImzaliEreceteAciklamaEkle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteAciklamaEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named imzaliEreceteIlacAciklamaEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImzaliEreceteIlacAciklamaEkle $parameters
     * @return \StructType\ImzaliEreceteIlacAciklamaEkleResponse|bool
     */
    public function imzaliEreceteIlacAciklamaEkle(\StructType\ImzaliEreceteIlacAciklamaEkle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->imzaliEreceteIlacAciklamaEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImzaliEreceteAciklamaEkleResponse|\StructType\ImzaliEreceteGirisResponse|\StructType\ImzaliEreceteIlacAciklamaEkleResponse|\StructType\ImzaliEreceteListeSorguResponse|\StructType\ImzaliEreceteOnayIptalResponse|\StructType\ImzaliEreceteOnayResponse|\StructType\ImzaliEreceteSilResponse|\StructType\ImzaliEreceteSorguResponse|\StructType\ImzaliEreceteTaniEkleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
