<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webUIComponents StructType
 * @subpackage Structs
 */
class WebUIComponents extends AbstractStructBase
{
    /**
     * The webUIComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\WebUIComponent[]
     */
    public $webUIComponent;
    /**
     * Constructor method for webUIComponents
     * @uses WebUIComponents::setWebUIComponent()
     * @param \QCC\CampusM\CloudService\StructType\WebUIComponent[] $webUIComponent
     */
    public function __construct(array $webUIComponent = array())
    {
        $this
            ->setWebUIComponent($webUIComponent);
    }
    /**
     * Get webUIComponent value
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent[]|null
     */
    public function getWebUIComponent()
    {
        return $this->webUIComponent;
    }
    /**
     * Set webUIComponent value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\WebUIComponent[] $webUIComponent
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponents
     */
    public function setWebUIComponent(array $webUIComponent = array())
    {
        foreach ($webUIComponent as $webUIComponentsWebUIComponentItem) {
            // validation for constraint: itemType
            if (!$webUIComponentsWebUIComponentItem instanceof \QCC\CampusM\CloudService\StructType\WebUIComponent) {
                throw new \InvalidArgumentException(sprintf('The webUIComponent property can only contain items of \QCC\CampusM\CloudService\StructType\WebUIComponent, "%s" given', is_object($webUIComponentsWebUIComponentItem) ? get_class($webUIComponentsWebUIComponentItem) : gettype($webUIComponentsWebUIComponentItem)), __LINE__);
            }
        }
        $this->webUIComponent = $webUIComponent;
        return $this;
    }
    /**
     * Add item to webUIComponent value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\WebUIComponent $item
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponents
     */
    public function addToWebUIComponent(\QCC\CampusM\CloudService\StructType\WebUIComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\WebUIComponent) {
            throw new \InvalidArgumentException(sprintf('The webUIComponent property can only contain items of \QCC\CampusM\CloudService\StructType\WebUIComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->webUIComponent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
