<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webUIComponent StructType
 * @subpackage Structs
 */
class WebUIComponent extends AbstractStructBase
{
    /**
     * The menuRefCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $menuRefCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $path;
    /**
     * The pgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pgCode;
    /**
     * The preCache
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $preCache;
    /**
     * The gpsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gpsEnabled;
    /**
     * The lastUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastUpdated;
    /**
     * The ssoProtected
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ssoProtected;
    /**
     * Constructor method for webUIComponent
     * @uses WebUIComponent::setMenuRefCode()
     * @uses WebUIComponent::setDescription()
     * @uses WebUIComponent::setPath()
     * @uses WebUIComponent::setPgCode()
     * @uses WebUIComponent::setPreCache()
     * @uses WebUIComponent::setGpsEnabled()
     * @uses WebUIComponent::setLastUpdated()
     * @uses WebUIComponent::setSsoProtected()
     * @param string $menuRefCode
     * @param string $description
     * @param string $path
     * @param int $pgCode
     * @param string $preCache
     * @param string $gpsEnabled
     * @param string $lastUpdated
     * @param string $ssoProtected
     */
    public function __construct($menuRefCode = null, $description = null, $path = null, $pgCode = null, $preCache = null, $gpsEnabled = null, $lastUpdated = null, $ssoProtected = null)
    {
        $this
            ->setMenuRefCode($menuRefCode)
            ->setDescription($description)
            ->setPath($path)
            ->setPgCode($pgCode)
            ->setPreCache($preCache)
            ->setGpsEnabled($gpsEnabled)
            ->setLastUpdated($lastUpdated)
            ->setSsoProtected($ssoProtected);
    }
    /**
     * Get menuRefCode value
     * @return string|null
     */
    public function getMenuRefCode()
    {
        return $this->menuRefCode;
    }
    /**
     * Set menuRefCode value
     * @param string $menuRefCode
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setMenuRefCode($menuRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($menuRefCode) && !is_string($menuRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuRefCode)), __LINE__);
        }
        $this->menuRefCode = $menuRefCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Get pgCode value
     * @return int|null
     */
    public function getPgCode()
    {
        return $this->pgCode;
    }
    /**
     * Set pgCode value
     * @param int $pgCode
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setPgCode($pgCode = null)
    {
        // validation for constraint: int
        if (!is_null($pgCode) && !is_numeric($pgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pgCode)), __LINE__);
        }
        $this->pgCode = $pgCode;
        return $this;
    }
    /**
     * Get preCache value
     * @return string|null
     */
    public function getPreCache()
    {
        return $this->preCache;
    }
    /**
     * Set preCache value
     * @param string $preCache
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setPreCache($preCache = null)
    {
        // validation for constraint: string
        if (!is_null($preCache) && !is_string($preCache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preCache)), __LINE__);
        }
        $this->preCache = $preCache;
        return $this;
    }
    /**
     * Get gpsEnabled value
     * @return string|null
     */
    public function getGpsEnabled()
    {
        return $this->gpsEnabled;
    }
    /**
     * Set gpsEnabled value
     * @param string $gpsEnabled
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setGpsEnabled($gpsEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($gpsEnabled) && !is_string($gpsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsEnabled)), __LINE__);
        }
        $this->gpsEnabled = $gpsEnabled;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get ssoProtected value
     * @return string|null
     */
    public function getSsoProtected()
    {
        return $this->ssoProtected;
    }
    /**
     * Set ssoProtected value
     * @param string $ssoProtected
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public function setSsoProtected($ssoProtected = null)
    {
        // validation for constraint: string
        if (!is_null($ssoProtected) && !is_string($ssoProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssoProtected)), __LINE__);
        }
        $this->ssoProtected = $ssoProtected;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\WebUIComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
