<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for valueItem StructType
 * @subpackage Structs
 */
class ValueItem extends AbstractStructBase
{
    /**
     * The valueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valueType;
    /**
     * The valueId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $valueId;
    /**
     * The valueCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valueCode;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * Constructor method for valueItem
     * @uses ValueItem::setValueType()
     * @uses ValueItem::setValueId()
     * @uses ValueItem::setValueCode()
     * @uses ValueItem::setContent()
     * @param string $valueType
     * @param int $valueId
     * @param string $valueCode
     * @param string $content
     */
    public function __construct($valueType = null, $valueId = null, $valueCode = null, $content = null)
    {
        $this
            ->setValueType($valueType)
            ->setValueId($valueId)
            ->setValueCode($valueCode)
            ->setContent($content);
    }
    /**
     * Get valueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @param string $valueType
     * @return \QCC\CampusM\CloudService\StructType\ValueItem
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valueType)), __LINE__);
        }
        $this->valueType = $valueType;
        return $this;
    }
    /**
     * Get valueId value
     * @return int|null
     */
    public function getValueId()
    {
        return $this->valueId;
    }
    /**
     * Set valueId value
     * @param int $valueId
     * @return \QCC\CampusM\CloudService\StructType\ValueItem
     */
    public function setValueId($valueId = null)
    {
        // validation for constraint: int
        if (!is_null($valueId) && !is_numeric($valueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($valueId)), __LINE__);
        }
        $this->valueId = $valueId;
        return $this;
    }
    /**
     * Get valueCode value
     * @return string|null
     */
    public function getValueCode()
    {
        return $this->valueCode;
    }
    /**
     * Set valueCode value
     * @param string $valueCode
     * @return \QCC\CampusM\CloudService\StructType\ValueItem
     */
    public function setValueCode($valueCode = null)
    {
        // validation for constraint: string
        if (!is_null($valueCode) && !is_string($valueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valueCode)), __LINE__);
        }
        $this->valueCode = $valueCode;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \QCC\CampusM\CloudService\StructType\ValueItem
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ValueItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
