<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLoginOAuthResponse StructType
 * @subpackage Structs
 */
class UserLoginOAuthResponse extends AbstractStructBase
{
    /**
     * The accessToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessToken;
    /**
     * The tokenType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tokenType;
    /**
     * The expiresIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiresIn;
    /**
     * The refreshToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refreshToken;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The newUser
     * @var bool
     */
    public $newUser;
    /**
     * The emailAddress
     * @var string
     */
    public $emailAddress;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The customerRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\CustomerRolesList
     */
    public $customerRoles;
    /**
     * The authedProfileIds
     * @var \QCC\CampusM\CloudService\StructType\ProfileIds
     */
    public $authedProfileIds;
    /**
     * Constructor method for userLoginOAuthResponse
     * @uses UserLoginOAuthResponse::setAccessToken()
     * @uses UserLoginOAuthResponse::setTokenType()
     * @uses UserLoginOAuthResponse::setExpiresIn()
     * @uses UserLoginOAuthResponse::setRefreshToken()
     * @uses UserLoginOAuthResponse::setPersonId()
     * @uses UserLoginOAuthResponse::setPassword()
     * @uses UserLoginOAuthResponse::setNewUser()
     * @uses UserLoginOAuthResponse::setEmailAddress()
     * @uses UserLoginOAuthResponse::setFirstName()
     * @uses UserLoginOAuthResponse::setSurname()
     * @uses UserLoginOAuthResponse::setCustomerRoles()
     * @uses UserLoginOAuthResponse::setAuthedProfileIds()
     * @param string $accessToken
     * @param string $tokenType
     * @param int $expiresIn
     * @param string $refreshToken
     * @param int $personId
     * @param string $password
     * @param bool $newUser
     * @param string $emailAddress
     * @param string $firstName
     * @param string $surname
     * @param \QCC\CampusM\CloudService\StructType\CustomerRolesList $customerRoles
     * @param \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds
     */
    public function __construct($accessToken = null, $tokenType = null, $expiresIn = null, $refreshToken = null, $personId = null, $password = null, $newUser = null, $emailAddress = null, $firstName = null, $surname = null, \QCC\CampusM\CloudService\StructType\CustomerRolesList $customerRoles = null, \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds = null)
    {
        $this
            ->setAccessToken($accessToken)
            ->setTokenType($tokenType)
            ->setExpiresIn($expiresIn)
            ->setRefreshToken($refreshToken)
            ->setPersonId($personId)
            ->setPassword($password)
            ->setNewUser($newUser)
            ->setEmailAddress($emailAddress)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setCustomerRoles($customerRoles)
            ->setAuthedProfileIds($authedProfileIds);
    }
    /**
     * Get accessToken value
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }
    /**
     * Set accessToken value
     * @param string $accessToken
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessToken)), __LINE__);
        }
        $this->accessToken = $accessToken;
        return $this;
    }
    /**
     * Get tokenType value
     * @return string|null
     */
    public function getTokenType()
    {
        return $this->tokenType;
    }
    /**
     * Set tokenType value
     * @param string $tokenType
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setTokenType($tokenType = null)
    {
        // validation for constraint: string
        if (!is_null($tokenType) && !is_string($tokenType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tokenType)), __LINE__);
        }
        $this->tokenType = $tokenType;
        return $this;
    }
    /**
     * Get expiresIn value
     * @return int|null
     */
    public function getExpiresIn()
    {
        return $this->expiresIn;
    }
    /**
     * Set expiresIn value
     * @param int $expiresIn
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setExpiresIn($expiresIn = null)
    {
        // validation for constraint: int
        if (!is_null($expiresIn) && !is_numeric($expiresIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expiresIn)), __LINE__);
        }
        $this->expiresIn = $expiresIn;
        return $this;
    }
    /**
     * Get refreshToken value
     * @return string|null
     */
    public function getRefreshToken()
    {
        return $this->refreshToken;
    }
    /**
     * Set refreshToken value
     * @param string $refreshToken
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setRefreshToken($refreshToken = null)
    {
        // validation for constraint: string
        if (!is_null($refreshToken) && !is_string($refreshToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refreshToken)), __LINE__);
        }
        $this->refreshToken = $refreshToken;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get newUser value
     * @return bool|null
     */
    public function getNewUser()
    {
        return $this->newUser;
    }
    /**
     * Set newUser value
     * @param bool $newUser
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setNewUser($newUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($newUser) && !is_bool($newUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($newUser)), __LINE__);
        }
        $this->newUser = $newUser;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get customerRoles value
     * @return \QCC\CampusM\CloudService\StructType\CustomerRolesList|null
     */
    public function getCustomerRoles()
    {
        return $this->customerRoles;
    }
    /**
     * Set customerRoles value
     * @param \QCC\CampusM\CloudService\StructType\CustomerRolesList $customerRoles
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setCustomerRoles(\QCC\CampusM\CloudService\StructType\CustomerRolesList $customerRoles = null)
    {
        $this->customerRoles = $customerRoles;
        return $this;
    }
    /**
     * Get authedProfileIds value
     * @return \QCC\CampusM\CloudService\StructType\ProfileIds|null
     */
    public function getAuthedProfileIds()
    {
        return $this->authedProfileIds;
    }
    /**
     * Set authedProfileIds value
     * @param \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public function setAuthedProfileIds(\QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds = null)
    {
        $this->authedProfileIds = $authedProfileIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
