<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLoginOAuthRequest StructType
 * @subpackage Structs
 */
class UserLoginOAuthRequest extends AbstractStructBase
{
    /**
     * The authorizationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $authorizationCode;
    /**
     * The accessToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessToken;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The profileGroupId
     * @var int
     */
    public $profileGroupId;
    /**
     * The platform
     * @var string
     */
    public $platform;
    /**
     * The callbackURLType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callbackURLType;
    /**
     * Constructor method for userLoginOAuthRequest
     * @uses UserLoginOAuthRequest::setAuthorizationCode()
     * @uses UserLoginOAuthRequest::setAccessToken()
     * @uses UserLoginOAuthRequest::setOrgCode()
     * @uses UserLoginOAuthRequest::setOrgMobilePassword()
     * @uses UserLoginOAuthRequest::setProfileGroupId()
     * @uses UserLoginOAuthRequest::setPlatform()
     * @uses UserLoginOAuthRequest::setCallbackURLType()
     * @param string $authorizationCode
     * @param string $accessToken
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param int $profileGroupId
     * @param string $platform
     * @param string $callbackURLType
     */
    public function __construct($authorizationCode = null, $accessToken = null, $orgCode = null, $orgMobilePassword = null, $profileGroupId = null, $platform = null, $callbackURLType = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setAccessToken($accessToken)
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setProfileGroupId($profileGroupId)
            ->setPlatform($platform)
            ->setCallbackURLType($callbackURLType);
    }
    /**
     * Get authorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->authorizationCode;
    }
    /**
     * Set authorizationCode value
     * @param string $authorizationCode
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->authorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get accessToken value
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }
    /**
     * Set accessToken value
     * @param string $accessToken
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessToken)), __LINE__);
        }
        $this->accessToken = $accessToken;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get profileGroupId value
     * @return int|null
     */
    public function getProfileGroupId()
    {
        return $this->profileGroupId;
    }
    /**
     * Set profileGroupId value
     * @param int $profileGroupId
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setProfileGroupId($profileGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($profileGroupId) && !is_numeric($profileGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileGroupId)), __LINE__);
        }
        $this->profileGroupId = $profileGroupId;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get callbackURLType value
     * @return string|null
     */
    public function getCallbackURLType()
    {
        return $this->callbackURLType;
    }
    /**
     * Set callbackURLType value
     * @param string $callbackURLType
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public function setCallbackURLType($callbackURLType = null)
    {
        // validation for constraint: string
        if (!is_null($callbackURLType) && !is_string($callbackURLType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callbackURLType)), __LINE__);
        }
        $this->callbackURLType = $callbackURLType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
