<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sitem StructType
 * @subpackage Structs
 */
class Sitem extends AbstractStructBase
{
    /**
     * The sname
     * @var string
     */
    public $sname;
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $server;
    /**
     * The endPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endPoint;
    /**
     * The basicAuthUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $basicAuthUser;
    /**
     * The basicAuthPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $basicAuthPassword;
    /**
     * The promptEveryTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $promptEveryTime;
    /**
     * The skipAuth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $skipAuth;
    /**
     * The proxyAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $proxyAddress;
    /**
     * The proxyUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $proxyUrl;
    /**
     * The proxyKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $proxyKey;
    /**
     * The applyTimeOffset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applyTimeOffset;
    /**
     * The positionsFormatId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $positionsFormatId;
    /**
     * The positionsFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\PositionsFeedFormat
     */
    public $positionsFormat;
    /**
     * The ldapServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapServiceType;
    /**
     * The timetableRefreshFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timetableRefreshFrequency;
    /**
     * The timetableRefreshCacheWindow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timetableRefreshCacheWindow;
    /**
     * The timetableRefreshPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timetableRefreshPriority;
    /**
     * Constructor method for sitem
     * @uses Sitem::setSname()
     * @uses Sitem::setServer()
     * @uses Sitem::setEndPoint()
     * @uses Sitem::setBasicAuthUser()
     * @uses Sitem::setBasicAuthPassword()
     * @uses Sitem::setPromptEveryTime()
     * @uses Sitem::setSkipAuth()
     * @uses Sitem::setProxyAddress()
     * @uses Sitem::setProxyUrl()
     * @uses Sitem::setProxyKey()
     * @uses Sitem::setApplyTimeOffset()
     * @uses Sitem::setPositionsFormatId()
     * @uses Sitem::setPositionsFormat()
     * @uses Sitem::setLdapServiceType()
     * @uses Sitem::setTimetableRefreshFrequency()
     * @uses Sitem::setTimetableRefreshCacheWindow()
     * @uses Sitem::setTimetableRefreshPriority()
     * @param string $sname
     * @param string $server
     * @param string $endPoint
     * @param string $basicAuthUser
     * @param string $basicAuthPassword
     * @param string $promptEveryTime
     * @param string $skipAuth
     * @param string $proxyAddress
     * @param string $proxyUrl
     * @param string $proxyKey
     * @param string $applyTimeOffset
     * @param int $positionsFormatId
     * @param \QCC\CampusM\CloudService\StructType\PositionsFeedFormat $positionsFormat
     * @param string $ldapServiceType
     * @param int $timetableRefreshFrequency
     * @param int $timetableRefreshCacheWindow
     * @param int $timetableRefreshPriority
     */
    public function __construct($sname = null, $server = null, $endPoint = null, $basicAuthUser = null, $basicAuthPassword = null, $promptEveryTime = null, $skipAuth = null, $proxyAddress = null, $proxyUrl = null, $proxyKey = null, $applyTimeOffset = null, $positionsFormatId = null, \QCC\CampusM\CloudService\StructType\PositionsFeedFormat $positionsFormat = null, $ldapServiceType = null, $timetableRefreshFrequency = null, $timetableRefreshCacheWindow = null, $timetableRefreshPriority = null)
    {
        $this
            ->setSname($sname)
            ->setServer($server)
            ->setEndPoint($endPoint)
            ->setBasicAuthUser($basicAuthUser)
            ->setBasicAuthPassword($basicAuthPassword)
            ->setPromptEveryTime($promptEveryTime)
            ->setSkipAuth($skipAuth)
            ->setProxyAddress($proxyAddress)
            ->setProxyUrl($proxyUrl)
            ->setProxyKey($proxyKey)
            ->setApplyTimeOffset($applyTimeOffset)
            ->setPositionsFormatId($positionsFormatId)
            ->setPositionsFormat($positionsFormat)
            ->setLdapServiceType($ldapServiceType)
            ->setTimetableRefreshFrequency($timetableRefreshFrequency)
            ->setTimetableRefreshCacheWindow($timetableRefreshCacheWindow)
            ->setTimetableRefreshPriority($timetableRefreshPriority);
    }
    /**
     * Get sname value
     * @return string|null
     */
    public function getSname()
    {
        return $this->sname;
    }
    /**
     * Set sname value
     * @param string $sname
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setSname($sname = null)
    {
        // validation for constraint: string
        if (!is_null($sname) && !is_string($sname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sname)), __LINE__);
        }
        $this->sname = $sname;
        return $this;
    }
    /**
     * Get server value
     * @return string|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param string $server
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setServer($server = null)
    {
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($server)), __LINE__);
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Get endPoint value
     * @return string|null
     */
    public function getEndPoint()
    {
        return $this->endPoint;
    }
    /**
     * Set endPoint value
     * @param string $endPoint
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setEndPoint($endPoint = null)
    {
        // validation for constraint: string
        if (!is_null($endPoint) && !is_string($endPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endPoint)), __LINE__);
        }
        $this->endPoint = $endPoint;
        return $this;
    }
    /**
     * Get basicAuthUser value
     * @return string|null
     */
    public function getBasicAuthUser()
    {
        return $this->basicAuthUser;
    }
    /**
     * Set basicAuthUser value
     * @param string $basicAuthUser
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setBasicAuthUser($basicAuthUser = null)
    {
        // validation for constraint: string
        if (!is_null($basicAuthUser) && !is_string($basicAuthUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basicAuthUser)), __LINE__);
        }
        $this->basicAuthUser = $basicAuthUser;
        return $this;
    }
    /**
     * Get basicAuthPassword value
     * @return string|null
     */
    public function getBasicAuthPassword()
    {
        return $this->basicAuthPassword;
    }
    /**
     * Set basicAuthPassword value
     * @param string $basicAuthPassword
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setBasicAuthPassword($basicAuthPassword = null)
    {
        // validation for constraint: string
        if (!is_null($basicAuthPassword) && !is_string($basicAuthPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basicAuthPassword)), __LINE__);
        }
        $this->basicAuthPassword = $basicAuthPassword;
        return $this;
    }
    /**
     * Get promptEveryTime value
     * @return string|null
     */
    public function getPromptEveryTime()
    {
        return $this->promptEveryTime;
    }
    /**
     * Set promptEveryTime value
     * @param string $promptEveryTime
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setPromptEveryTime($promptEveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($promptEveryTime) && !is_string($promptEveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promptEveryTime)), __LINE__);
        }
        $this->promptEveryTime = $promptEveryTime;
        return $this;
    }
    /**
     * Get skipAuth value
     * @return string|null
     */
    public function getSkipAuth()
    {
        return $this->skipAuth;
    }
    /**
     * Set skipAuth value
     * @param string $skipAuth
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setSkipAuth($skipAuth = null)
    {
        // validation for constraint: string
        if (!is_null($skipAuth) && !is_string($skipAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skipAuth)), __LINE__);
        }
        $this->skipAuth = $skipAuth;
        return $this;
    }
    /**
     * Get proxyAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProxyAddress()
    {
        return isset($this->proxyAddress) ? $this->proxyAddress : null;
    }
    /**
     * Set proxyAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proxyAddress
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setProxyAddress($proxyAddress = null)
    {
        // validation for constraint: string
        if (!is_null($proxyAddress) && !is_string($proxyAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyAddress)), __LINE__);
        }
        if (is_null($proxyAddress) || (is_array($proxyAddress) && empty($proxyAddress))) {
            unset($this->proxyAddress);
        } else {
            $this->proxyAddress = $proxyAddress;
        }
        return $this;
    }
    /**
     * Get proxyUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProxyUrl()
    {
        return isset($this->proxyUrl) ? $this->proxyUrl : null;
    }
    /**
     * Set proxyUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proxyUrl
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setProxyUrl($proxyUrl = null)
    {
        // validation for constraint: string
        if (!is_null($proxyUrl) && !is_string($proxyUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyUrl)), __LINE__);
        }
        if (is_null($proxyUrl) || (is_array($proxyUrl) && empty($proxyUrl))) {
            unset($this->proxyUrl);
        } else {
            $this->proxyUrl = $proxyUrl;
        }
        return $this;
    }
    /**
     * Get proxyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProxyKey()
    {
        return isset($this->proxyKey) ? $this->proxyKey : null;
    }
    /**
     * Set proxyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proxyKey
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setProxyKey($proxyKey = null)
    {
        // validation for constraint: string
        if (!is_null($proxyKey) && !is_string($proxyKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyKey)), __LINE__);
        }
        if (is_null($proxyKey) || (is_array($proxyKey) && empty($proxyKey))) {
            unset($this->proxyKey);
        } else {
            $this->proxyKey = $proxyKey;
        }
        return $this;
    }
    /**
     * Get applyTimeOffset value
     * @return string|null
     */
    public function getApplyTimeOffset()
    {
        return $this->applyTimeOffset;
    }
    /**
     * Set applyTimeOffset value
     * @param string $applyTimeOffset
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setApplyTimeOffset($applyTimeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($applyTimeOffset) && !is_string($applyTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applyTimeOffset)), __LINE__);
        }
        $this->applyTimeOffset = $applyTimeOffset;
        return $this;
    }
    /**
     * Get positionsFormatId value
     * @return int|null
     */
    public function getPositionsFormatId()
    {
        return $this->positionsFormatId;
    }
    /**
     * Set positionsFormatId value
     * @param int $positionsFormatId
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setPositionsFormatId($positionsFormatId = null)
    {
        // validation for constraint: int
        if (!is_null($positionsFormatId) && !is_numeric($positionsFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($positionsFormatId)), __LINE__);
        }
        $this->positionsFormatId = $positionsFormatId;
        return $this;
    }
    /**
     * Get positionsFormat value
     * @return \QCC\CampusM\CloudService\StructType\PositionsFeedFormat|null
     */
    public function getPositionsFormat()
    {
        return $this->positionsFormat;
    }
    /**
     * Set positionsFormat value
     * @param \QCC\CampusM\CloudService\StructType\PositionsFeedFormat $positionsFormat
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setPositionsFormat(\QCC\CampusM\CloudService\StructType\PositionsFeedFormat $positionsFormat = null)
    {
        $this->positionsFormat = $positionsFormat;
        return $this;
    }
    /**
     * Get ldapServiceType value
     * @return string|null
     */
    public function getLdapServiceType()
    {
        return $this->ldapServiceType;
    }
    /**
     * Set ldapServiceType value
     * @param string $ldapServiceType
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setLdapServiceType($ldapServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($ldapServiceType) && !is_string($ldapServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapServiceType)), __LINE__);
        }
        $this->ldapServiceType = $ldapServiceType;
        return $this;
    }
    /**
     * Get timetableRefreshFrequency value
     * @return int|null
     */
    public function getTimetableRefreshFrequency()
    {
        return $this->timetableRefreshFrequency;
    }
    /**
     * Set timetableRefreshFrequency value
     * @param int $timetableRefreshFrequency
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setTimetableRefreshFrequency($timetableRefreshFrequency = null)
    {
        // validation for constraint: int
        if (!is_null($timetableRefreshFrequency) && !is_numeric($timetableRefreshFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timetableRefreshFrequency)), __LINE__);
        }
        $this->timetableRefreshFrequency = $timetableRefreshFrequency;
        return $this;
    }
    /**
     * Get timetableRefreshCacheWindow value
     * @return int|null
     */
    public function getTimetableRefreshCacheWindow()
    {
        return $this->timetableRefreshCacheWindow;
    }
    /**
     * Set timetableRefreshCacheWindow value
     * @param int $timetableRefreshCacheWindow
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setTimetableRefreshCacheWindow($timetableRefreshCacheWindow = null)
    {
        // validation for constraint: int
        if (!is_null($timetableRefreshCacheWindow) && !is_numeric($timetableRefreshCacheWindow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timetableRefreshCacheWindow)), __LINE__);
        }
        $this->timetableRefreshCacheWindow = $timetableRefreshCacheWindow;
        return $this;
    }
    /**
     * Get timetableRefreshPriority value
     * @return int|null
     */
    public function getTimetableRefreshPriority()
    {
        return $this->timetableRefreshPriority;
    }
    /**
     * Set timetableRefreshPriority value
     * @param int $timetableRefreshPriority
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public function setTimetableRefreshPriority($timetableRefreshPriority = null)
    {
        // validation for constraint: int
        if (!is_null($timetableRefreshPriority) && !is_numeric($timetableRefreshPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timetableRefreshPriority)), __LINE__);
        }
        $this->timetableRefreshPriority = $timetableRefreshPriority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Sitem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
