<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setupUserRequest StructType
 * @subpackage Structs
 */
class SetupUserRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The roleCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $roleCode;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The appRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\AppRoleNameList
     */
    public $appRoles;
    /**
     * The platform
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $platform;
    /**
     * The osVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $osVersion;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The phoneModel
     * @var string
     */
    public $phoneModel;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The telNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telNo;
    /**
     * The menuLastUpdated
     * @var string
     */
    public $menuLastUpdated;
    /**
     * The rssLastUpdated
     * @var string
     */
    public $rssLastUpdated;
    /**
     * The mapsLastUpdated
     * @var string
     */
    public $mapsLastUpdated;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The emailAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\EmailAddresses
     */
    public $emailAddresses;
    /**
     * The optOut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $optOut;
    /**
     * The userType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userType;
    /**
     * The rolesLoadFailed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $rolesLoadFailed;
    /**
     * Constructor method for setupUserRequest
     * @uses SetupUserRequest::setOrgCode()
     * @uses SetupUserRequest::setRoleCode()
     * @uses SetupUserRequest::setProfileId()
     * @uses SetupUserRequest::setAppRoles()
     * @uses SetupUserRequest::setPlatform()
     * @uses SetupUserRequest::setOsVersion()
     * @uses SetupUserRequest::setModel()
     * @uses SetupUserRequest::setPhoneModel()
     * @uses SetupUserRequest::setFirstName()
     * @uses SetupUserRequest::setSurname()
     * @uses SetupUserRequest::setPersonId()
     * @uses SetupUserRequest::setEmailAddress()
     * @uses SetupUserRequest::setTelNo()
     * @uses SetupUserRequest::setMenuLastUpdated()
     * @uses SetupUserRequest::setRssLastUpdated()
     * @uses SetupUserRequest::setMapsLastUpdated()
     * @uses SetupUserRequest::setPassword()
     * @uses SetupUserRequest::setOrgMobilePassword()
     * @uses SetupUserRequest::setEmailAddresses()
     * @uses SetupUserRequest::setOptOut()
     * @uses SetupUserRequest::setUserType()
     * @uses SetupUserRequest::setRolesLoadFailed()
     * @param int $orgCode
     * @param int $roleCode
     * @param int $profileId
     * @param \QCC\CampusM\CloudService\StructType\AppRoleNameList $appRoles
     * @param string $platform
     * @param string $osVersion
     * @param string $model
     * @param string $phoneModel
     * @param string $firstName
     * @param string $surname
     * @param int $personId
     * @param string $emailAddress
     * @param string $telNo
     * @param string $menuLastUpdated
     * @param string $rssLastUpdated
     * @param string $mapsLastUpdated
     * @param string $password
     * @param string $orgMobilePassword
     * @param \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses
     * @param string $optOut
     * @param string $userType
     * @param bool $rolesLoadFailed
     */
    public function __construct($orgCode = null, $roleCode = null, $profileId = null, \QCC\CampusM\CloudService\StructType\AppRoleNameList $appRoles = null, $platform = null, $osVersion = null, $model = null, $phoneModel = null, $firstName = null, $surname = null, $personId = null, $emailAddress = null, $telNo = null, $menuLastUpdated = null, $rssLastUpdated = null, $mapsLastUpdated = null, $password = null, $orgMobilePassword = null, \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses = null, $optOut = null, $userType = null, $rolesLoadFailed = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setRoleCode($roleCode)
            ->setProfileId($profileId)
            ->setAppRoles($appRoles)
            ->setPlatform($platform)
            ->setOsVersion($osVersion)
            ->setModel($model)
            ->setPhoneModel($phoneModel)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setPersonId($personId)
            ->setEmailAddress($emailAddress)
            ->setTelNo($telNo)
            ->setMenuLastUpdated($menuLastUpdated)
            ->setRssLastUpdated($rssLastUpdated)
            ->setMapsLastUpdated($mapsLastUpdated)
            ->setPassword($password)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setEmailAddresses($emailAddresses)
            ->setOptOut($optOut)
            ->setUserType($userType)
            ->setRolesLoadFailed($rolesLoadFailed);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get roleCode value
     * @return int|null
     */
    public function getRoleCode()
    {
        return $this->roleCode;
    }
    /**
     * Set roleCode value
     * @param int $roleCode
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setRoleCode($roleCode = null)
    {
        // validation for constraint: int
        if (!is_null($roleCode) && !is_numeric($roleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roleCode)), __LINE__);
        }
        $this->roleCode = $roleCode;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get appRoles value
     * @return \QCC\CampusM\CloudService\StructType\AppRoleNameList|null
     */
    public function getAppRoles()
    {
        return $this->appRoles;
    }
    /**
     * Set appRoles value
     * @param \QCC\CampusM\CloudService\StructType\AppRoleNameList $appRoles
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setAppRoles(\QCC\CampusM\CloudService\StructType\AppRoleNameList $appRoles = null)
    {
        $this->appRoles = $appRoles;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get osVersion value
     * @return string|null
     */
    public function getOsVersion()
    {
        return $this->osVersion;
    }
    /**
     * Set osVersion value
     * @param string $osVersion
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($osVersion)), __LINE__);
        }
        $this->osVersion = $osVersion;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get phoneModel value
     * @return string|null
     */
    public function getPhoneModel()
    {
        return $this->phoneModel;
    }
    /**
     * Set phoneModel value
     * @param string $phoneModel
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setPhoneModel($phoneModel = null)
    {
        // validation for constraint: string
        if (!is_null($phoneModel) && !is_string($phoneModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneModel)), __LINE__);
        }
        $this->phoneModel = $phoneModel;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get telNo value
     * @return string|null
     */
    public function getTelNo()
    {
        return $this->telNo;
    }
    /**
     * Set telNo value
     * @param string $telNo
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setTelNo($telNo = null)
    {
        // validation for constraint: string
        if (!is_null($telNo) && !is_string($telNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telNo)), __LINE__);
        }
        $this->telNo = $telNo;
        return $this;
    }
    /**
     * Get menuLastUpdated value
     * @return string|null
     */
    public function getMenuLastUpdated()
    {
        return $this->menuLastUpdated;
    }
    /**
     * Set menuLastUpdated value
     * @param string $menuLastUpdated
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setMenuLastUpdated($menuLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($menuLastUpdated) && !is_string($menuLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuLastUpdated)), __LINE__);
        }
        $this->menuLastUpdated = $menuLastUpdated;
        return $this;
    }
    /**
     * Get rssLastUpdated value
     * @return string|null
     */
    public function getRssLastUpdated()
    {
        return $this->rssLastUpdated;
    }
    /**
     * Set rssLastUpdated value
     * @param string $rssLastUpdated
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setRssLastUpdated($rssLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($rssLastUpdated) && !is_string($rssLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rssLastUpdated)), __LINE__);
        }
        $this->rssLastUpdated = $rssLastUpdated;
        return $this;
    }
    /**
     * Get mapsLastUpdated value
     * @return string|null
     */
    public function getMapsLastUpdated()
    {
        return $this->mapsLastUpdated;
    }
    /**
     * Set mapsLastUpdated value
     * @param string $mapsLastUpdated
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setMapsLastUpdated($mapsLastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($mapsLastUpdated) && !is_string($mapsLastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mapsLastUpdated)), __LINE__);
        }
        $this->mapsLastUpdated = $mapsLastUpdated;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get emailAddresses value
     * @return \QCC\CampusM\CloudService\StructType\EmailAddresses|null
     */
    public function getEmailAddresses()
    {
        return $this->emailAddresses;
    }
    /**
     * Set emailAddresses value
     * @param \QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setEmailAddresses(\QCC\CampusM\CloudService\StructType\EmailAddresses $emailAddresses = null)
    {
        $this->emailAddresses = $emailAddresses;
        return $this;
    }
    /**
     * Get optOut value
     * @return string|null
     */
    public function getOptOut()
    {
        return $this->optOut;
    }
    /**
     * Set optOut value
     * @uses \QCC\CampusM\CloudService\EnumType\YesNo::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\YesNo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optOut
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setOptOut($optOut = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\YesNo::valueIsValid($optOut)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optOut, implode(', ', \QCC\CampusM\CloudService\EnumType\YesNo::getValidValues())), __LINE__);
        }
        $this->optOut = $optOut;
        return $this;
    }
    /**
     * Get userType value
     * @return string|null
     */
    public function getUserType()
    {
        return $this->userType;
    }
    /**
     * Set userType value
     * @param string $userType
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userType)), __LINE__);
        }
        $this->userType = $userType;
        return $this;
    }
    /**
     * Get rolesLoadFailed value
     * @return bool|null
     */
    public function getRolesLoadFailed()
    {
        return $this->rolesLoadFailed;
    }
    /**
     * Set rolesLoadFailed value
     * @param bool $rolesLoadFailed
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public function setRolesLoadFailed($rolesLoadFailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($rolesLoadFailed) && !is_bool($rolesLoadFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rolesLoadFailed)), __LINE__);
        }
        $this->rolesLoadFailed = $rolesLoadFailed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SetupUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
