<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saveJobPreferences StructType
 * @subpackage Structs
 */
class SaveJobPreferences extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $notifications;
    /**
     * The regions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Regions
     */
    public $regions;
    /**
     * The typesOfWork
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\TypesOfWork
     */
    public $typesOfWork;
    /**
     * The workhours
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Workhours
     */
    public $workhours;
    /**
     * Constructor method for saveJobPreferences
     * @uses SaveJobPreferences::setPersonId()
     * @uses SaveJobPreferences::setPassword()
     * @uses SaveJobPreferences::setOrgCode()
     * @uses SaveJobPreferences::setNotifications()
     * @uses SaveJobPreferences::setRegions()
     * @uses SaveJobPreferences::setTypesOfWork()
     * @uses SaveJobPreferences::setWorkhours()
     * @param int $personId
     * @param string $password
     * @param int $orgCode
     * @param bool $notifications
     * @param \QCC\CampusM\CloudService\StructType\Regions $regions
     * @param \QCC\CampusM\CloudService\StructType\TypesOfWork $typesOfWork
     * @param \QCC\CampusM\CloudService\StructType\Workhours $workhours
     */
    public function __construct($personId = null, $password = null, $orgCode = null, $notifications = null, \QCC\CampusM\CloudService\StructType\Regions $regions = null, \QCC\CampusM\CloudService\StructType\TypesOfWork $typesOfWork = null, \QCC\CampusM\CloudService\StructType\Workhours $workhours = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setOrgCode($orgCode)
            ->setNotifications($notifications)
            ->setRegions($regions)
            ->setTypesOfWork($typesOfWork)
            ->setWorkhours($workhours);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get notifications value
     * @return bool|null
     */
    public function getNotifications()
    {
        return $this->notifications;
    }
    /**
     * Set notifications value
     * @param bool $notifications
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setNotifications($notifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifications) && !is_bool($notifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifications)), __LINE__);
        }
        $this->notifications = $notifications;
        return $this;
    }
    /**
     * Get regions value
     * @return \QCC\CampusM\CloudService\StructType\Regions|null
     */
    public function getRegions()
    {
        return $this->regions;
    }
    /**
     * Set regions value
     * @param \QCC\CampusM\CloudService\StructType\Regions $regions
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setRegions(\QCC\CampusM\CloudService\StructType\Regions $regions = null)
    {
        $this->regions = $regions;
        return $this;
    }
    /**
     * Get typesOfWork value
     * @return \QCC\CampusM\CloudService\StructType\TypesOfWork|null
     */
    public function getTypesOfWork()
    {
        return $this->typesOfWork;
    }
    /**
     * Set typesOfWork value
     * @param \QCC\CampusM\CloudService\StructType\TypesOfWork $typesOfWork
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setTypesOfWork(\QCC\CampusM\CloudService\StructType\TypesOfWork $typesOfWork = null)
    {
        $this->typesOfWork = $typesOfWork;
        return $this;
    }
    /**
     * Get workhours value
     * @return \QCC\CampusM\CloudService\StructType\Workhours|null
     */
    public function getWorkhours()
    {
        return $this->workhours;
    }
    /**
     * Set workhours value
     * @param \QCC\CampusM\CloudService\StructType\Workhours $workhours
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public function setWorkhours(\QCC\CampusM\CloudService\StructType\Workhours $workhours = null)
    {
        $this->workhours = $workhours;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SaveJobPreferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
