<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resource StructType
 * @subpackage Structs
 */
class Resource extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The lastUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastUpdated;
    /**
     * Constructor method for resource
     * @uses Resource::setId()
     * @uses Resource::setDescription()
     * @uses Resource::setUrl()
     * @uses Resource::setType()
     * @uses Resource::setLastUpdated()
     * @param int $id
     * @param string $description
     * @param string $url
     * @param string $type
     * @param string $lastUpdated
     */
    public function __construct($id = null, $description = null, $url = null, $type = null, $lastUpdated = null)
    {
        $this
            ->setId($id)
            ->setDescription($description)
            ->setUrl($url)
            ->setType($type)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Resource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
