<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for regProcessRequest StructType
 * @subpackage Structs
 */
class RegProcessRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orgCode;
    /**
     * The mobilePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePassword;
    /**
     * Constructor method for regProcessRequest
     * @uses RegProcessRequest::setOrgCode()
     * @uses RegProcessRequest::setMobilePassword()
     * @param int $orgCode
     * @param string $mobilePassword
     */
    public function __construct($orgCode = null, $mobilePassword = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setMobilePassword($mobilePassword);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\RegProcessRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get mobilePassword value
     * @return string|null
     */
    public function getMobilePassword()
    {
        return $this->mobilePassword;
    }
    /**
     * Set mobilePassword value
     * @param string $mobilePassword
     * @return \QCC\CampusM\CloudService\StructType\RegProcessRequest
     */
    public function setMobilePassword($mobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePassword) && !is_string($mobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePassword)), __LINE__);
        }
        $this->mobilePassword = $mobilePassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\RegProcessRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
