<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for readExpression StructType
 * @subpackage Structs
 */
class ReadExpression extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The expression
     * @var string
     */
    public $expression;
    /**
     * Constructor method for readExpression
     * @uses ReadExpression::setName()
     * @uses ReadExpression::setExpression()
     * @param string $name
     * @param string $expression
     */
    public function __construct($name = null, $expression = null)
    {
        $this
            ->setName($name)
            ->setExpression($expression);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \QCC\CampusM\CloudService\StructType\ReadExpression
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get expression value
     * @return string|null
     */
    public function getExpression()
    {
        return $this->expression;
    }
    /**
     * Set expression value
     * @param string $expression
     * @return \QCC\CampusM\CloudService\StructType\ReadExpression
     */
    public function setExpression($expression = null)
    {
        // validation for constraint: string
        if (!is_null($expression) && !is_string($expression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expression)), __LINE__);
        }
        $this->expression = $expression;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ReadExpression
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
