<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pushCentreStatus StructType
 * @subpackage Structs
 */
class PushCentreStatus extends AbstractStructBase
{
    /**
     * The nodeId
     * @var string
     */
    public $nodeId;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The platform
     * @var string
     */
    public $platform;
    /**
     * The pusherId
     * @var string
     */
    public $pusherId;
    /**
     * Constructor method for pushCentreStatus
     * @uses PushCentreStatus::setNodeId()
     * @uses PushCentreStatus::setOrgCode()
     * @uses PushCentreStatus::setPlatform()
     * @uses PushCentreStatus::setPusherId()
     * @param string $nodeId
     * @param int $orgCode
     * @param string $platform
     * @param string $pusherId
     */
    public function __construct($nodeId = null, $orgCode = null, $platform = null, $pusherId = null)
    {
        $this
            ->setNodeId($nodeId)
            ->setOrgCode($orgCode)
            ->setPlatform($platform)
            ->setPusherId($pusherId);
    }
    /**
     * Get nodeId value
     * @return string|null
     */
    public function getNodeId()
    {
        return $this->nodeId;
    }
    /**
     * Set nodeId value
     * @param string $nodeId
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatus
     */
    public function setNodeId($nodeId = null)
    {
        // validation for constraint: string
        if (!is_null($nodeId) && !is_string($nodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nodeId)), __LINE__);
        }
        $this->nodeId = $nodeId;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatus
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatus
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: string
        if (!is_null($platform) && !is_string($platform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($platform)), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get pusherId value
     * @return string|null
     */
    public function getPusherId()
    {
        return $this->pusherId;
    }
    /**
     * Set pusherId value
     * @param string $pusherId
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatus
     */
    public function setPusherId($pusherId = null)
    {
        // validation for constraint: string
        if (!is_null($pusherId) && !is_string($pusherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pusherId)), __LINE__);
        }
        $this->pusherId = $pusherId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
