<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for profileGroup StructType
 * @subpackage Structs
 */
class ProfileGroup extends AbstractStructBase
{
    /**
     * The groupId
     * @var int
     */
    public $groupId;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The subtype
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subtype;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortOrder;
    /**
     * The authAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\AuthAccess
     */
    public $authAccess;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * The localInformationIntroText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localInformationIntroText;
    /**
     * The profiles
     * @var \QCC\CampusM\CloudService\StructType\Profiles
     */
    public $profiles;
    /**
     * Constructor method for profileGroup
     * @uses ProfileGroup::setGroupId()
     * @uses ProfileGroup::setType()
     * @uses ProfileGroup::setSubtype()
     * @uses ProfileGroup::setDescription()
     * @uses ProfileGroup::setSortOrder()
     * @uses ProfileGroup::setAuthAccess()
     * @uses ProfileGroup::setInformation()
     * @uses ProfileGroup::setLocalInformationIntroText()
     * @uses ProfileGroup::setProfiles()
     * @param int $groupId
     * @param string $type
     * @param string $subtype
     * @param string $description
     * @param int $sortOrder
     * @param \QCC\CampusM\CloudService\StructType\AuthAccess $authAccess
     * @param string $information
     * @param string $localInformationIntroText
     * @param \QCC\CampusM\CloudService\StructType\Profiles $profiles
     */
    public function __construct($groupId = null, $type = null, $subtype = null, $description = null, $sortOrder = null, \QCC\CampusM\CloudService\StructType\AuthAccess $authAccess = null, $information = null, $localInformationIntroText = null, \QCC\CampusM\CloudService\StructType\Profiles $profiles = null)
    {
        $this
            ->setGroupId($groupId)
            ->setType($type)
            ->setSubtype($subtype)
            ->setDescription($description)
            ->setSortOrder($sortOrder)
            ->setAuthAccess($authAccess)
            ->setInformation($information)
            ->setLocalInformationIntroText($localInformationIntroText)
            ->setProfiles($profiles);
    }
    /**
     * Get groupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param int $groupId
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !is_numeric($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get subtype value
     * @return string|null
     */
    public function getSubtype()
    {
        return $this->subtype;
    }
    /**
     * Set subtype value
     * @param string $subtype
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setSubtype($subtype = null)
    {
        // validation for constraint: string
        if (!is_null($subtype) && !is_string($subtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subtype)), __LINE__);
        }
        $this->subtype = $subtype;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param int $sortOrder
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get authAccess value
     * @return \QCC\CampusM\CloudService\StructType\AuthAccess|null
     */
    public function getAuthAccess()
    {
        return $this->authAccess;
    }
    /**
     * Set authAccess value
     * @param \QCC\CampusM\CloudService\StructType\AuthAccess $authAccess
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setAuthAccess(\QCC\CampusM\CloudService\StructType\AuthAccess $authAccess = null)
    {
        $this->authAccess = $authAccess;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get localInformationIntroText value
     * @return string|null
     */
    public function getLocalInformationIntroText()
    {
        return $this->localInformationIntroText;
    }
    /**
     * Set localInformationIntroText value
     * @param string $localInformationIntroText
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setLocalInformationIntroText($localInformationIntroText = null)
    {
        // validation for constraint: string
        if (!is_null($localInformationIntroText) && !is_string($localInformationIntroText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localInformationIntroText)), __LINE__);
        }
        $this->localInformationIntroText = $localInformationIntroText;
        return $this;
    }
    /**
     * Get profiles value
     * @return \QCC\CampusM\CloudService\StructType\Profiles|null
     */
    public function getProfiles()
    {
        return $this->profiles;
    }
    /**
     * Set profiles value
     * @param \QCC\CampusM\CloudService\StructType\Profiles $profiles
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public function setProfiles(\QCC\CampusM\CloudService\StructType\Profiles $profiles = null)
    {
        $this->profiles = $profiles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ProfileGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
