<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for positions StructType
 * @subpackage Structs
 */
class Positions extends AbstractStructBase
{
    /**
     * The pitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Pitem[]
     */
    public $pitem;
    /**
     * Constructor method for positions
     * @uses Positions::setPitem()
     * @param \QCC\CampusM\CloudService\StructType\Pitem[] $pitem
     */
    public function __construct(array $pitem = array())
    {
        $this
            ->setPitem($pitem);
    }
    /**
     * Get pitem value
     * @return \QCC\CampusM\CloudService\StructType\Pitem[]|null
     */
    public function getPitem()
    {
        return $this->pitem;
    }
    /**
     * Set pitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Pitem[] $pitem
     * @return \QCC\CampusM\CloudService\StructType\Positions
     */
    public function setPitem(array $pitem = array())
    {
        foreach ($pitem as $positionsPitemItem) {
            // validation for constraint: itemType
            if (!$positionsPitemItem instanceof \QCC\CampusM\CloudService\StructType\Pitem) {
                throw new \InvalidArgumentException(sprintf('The pitem property can only contain items of \QCC\CampusM\CloudService\StructType\Pitem, "%s" given', is_object($positionsPitemItem) ? get_class($positionsPitemItem) : gettype($positionsPitemItem)), __LINE__);
            }
        }
        $this->pitem = $pitem;
        return $this;
    }
    /**
     * Add item to pitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Pitem $item
     * @return \QCC\CampusM\CloudService\StructType\Positions
     */
    public function addToPitem(\QCC\CampusM\CloudService\StructType\Pitem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Pitem) {
            throw new \InvalidArgumentException(sprintf('The pitem property can only contain items of \QCC\CampusM\CloudService\StructType\Pitem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pitem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Positions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
