<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for plist StructType
 * @subpackage Structs
 */
class Plist extends AbstractStructBase
{
    /**
     * The psnitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Psnitem[]
     */
    public $psnitem;
    /**
     * Constructor method for plist
     * @uses Plist::setPsnitem()
     * @param \QCC\CampusM\CloudService\StructType\Psnitem[] $psnitem
     */
    public function __construct(array $psnitem = array())
    {
        $this
            ->setPsnitem($psnitem);
    }
    /**
     * Get psnitem value
     * @return \QCC\CampusM\CloudService\StructType\Psnitem[]|null
     */
    public function getPsnitem()
    {
        return $this->psnitem;
    }
    /**
     * Set psnitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Psnitem[] $psnitem
     * @return \QCC\CampusM\CloudService\StructType\Plist
     */
    public function setPsnitem(array $psnitem = array())
    {
        foreach ($psnitem as $plistPsnitemItem) {
            // validation for constraint: itemType
            if (!$plistPsnitemItem instanceof \QCC\CampusM\CloudService\StructType\Psnitem) {
                throw new \InvalidArgumentException(sprintf('The psnitem property can only contain items of \QCC\CampusM\CloudService\StructType\Psnitem, "%s" given', is_object($plistPsnitemItem) ? get_class($plistPsnitemItem) : gettype($plistPsnitemItem)), __LINE__);
            }
        }
        $this->psnitem = $psnitem;
        return $this;
    }
    /**
     * Add item to psnitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Psnitem $item
     * @return \QCC\CampusM\CloudService\StructType\Plist
     */
    public function addToPsnitem(\QCC\CampusM\CloudService\StructType\Psnitem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Psnitem) {
            throw new \InvalidArgumentException(sprintf('The psnitem property can only contain items of \QCC\CampusM\CloudService\StructType\Psnitem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->psnitem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Plist
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
