<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for person StructType
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The vqCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $vqCode;
    /**
     * The inappropriate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inappropriate;
    /**
     * The newVote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $newVote;
    /**
     * The personVotes
     * @var \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public $personVotes;
    /**
     * The personTextResponses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\PersonTextResponses
     */
    public $personTextResponses;
    /**
     * Constructor method for person
     * @uses Person::setPersonId()
     * @uses Person::setPassword()
     * @uses Person::setVqCode()
     * @uses Person::setInappropriate()
     * @uses Person::setNewVote()
     * @uses Person::setPersonVotes()
     * @uses Person::setPersonTextResponses()
     * @param int $personId
     * @param string $password
     * @param int $vqCode
     * @param string $inappropriate
     * @param string $newVote
     * @param \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes
     * @param \QCC\CampusM\CloudService\StructType\PersonTextResponses $personTextResponses
     */
    public function __construct($personId = null, $password = null, $vqCode = null, $inappropriate = null, $newVote = null, \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes = null, \QCC\CampusM\CloudService\StructType\PersonTextResponses $personTextResponses = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setVqCode($vqCode)
            ->setInappropriate($inappropriate)
            ->setNewVote($newVote)
            ->setPersonVotes($personVotes)
            ->setPersonTextResponses($personTextResponses);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get vqCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVqCode()
    {
        return isset($this->vqCode) ? $this->vqCode : null;
    }
    /**
     * Set vqCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vqCode
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setVqCode($vqCode = null)
    {
        // validation for constraint: int
        if (!is_null($vqCode) && !is_numeric($vqCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vqCode)), __LINE__);
        }
        if (is_null($vqCode) || (is_array($vqCode) && empty($vqCode))) {
            unset($this->vqCode);
        } else {
            $this->vqCode = $vqCode;
        }
        return $this;
    }
    /**
     * Get inappropriate value
     * @return string|null
     */
    public function getInappropriate()
    {
        return $this->inappropriate;
    }
    /**
     * Set inappropriate value
     * @param string $inappropriate
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setInappropriate($inappropriate = null)
    {
        // validation for constraint: string
        if (!is_null($inappropriate) && !is_string($inappropriate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inappropriate)), __LINE__);
        }
        $this->inappropriate = $inappropriate;
        return $this;
    }
    /**
     * Get newVote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewVote()
    {
        return isset($this->newVote) ? $this->newVote : null;
    }
    /**
     * Set newVote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newVote
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setNewVote($newVote = null)
    {
        // validation for constraint: string
        if (!is_null($newVote) && !is_string($newVote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newVote)), __LINE__);
        }
        if (is_null($newVote) || (is_array($newVote) && empty($newVote))) {
            unset($this->newVote);
        } else {
            $this->newVote = $newVote;
        }
        return $this;
    }
    /**
     * Get personVotes value
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes|null
     */
    public function getPersonVotes()
    {
        return $this->personVotes;
    }
    /**
     * Set personVotes value
     * @param \QCC\CampusM\CloudService\StructType\PersonVotes $personVotes
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setPersonVotes(\QCC\CampusM\CloudService\StructType\PersonVotes $personVotes = null)
    {
        $this->personVotes = $personVotes;
        return $this;
    }
    /**
     * Get personTextResponses value
     * @return \QCC\CampusM\CloudService\StructType\PersonTextResponses|null
     */
    public function getPersonTextResponses()
    {
        return $this->personTextResponses;
    }
    /**
     * Set personTextResponses value
     * @param \QCC\CampusM\CloudService\StructType\PersonTextResponses $personTextResponses
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public function setPersonTextResponses(\QCC\CampusM\CloudService\StructType\PersonTextResponses $personTextResponses = null)
    {
        $this->personTextResponses = $personTextResponses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Person
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
