<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for oAuthRefreshResponse StructType
 * @subpackage Structs
 */
class OAuthRefreshResponse extends AbstractStructBase
{
    /**
     * The accessToken
     * @var string
     */
    public $accessToken;
    /**
     * The tokenType
     * @var string
     */
    public $tokenType;
    /**
     * The expiresIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiresIn;
    /**
     * The refreshToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refreshToken;
    /**
     * Constructor method for oAuthRefreshResponse
     * @uses OAuthRefreshResponse::setAccessToken()
     * @uses OAuthRefreshResponse::setTokenType()
     * @uses OAuthRefreshResponse::setExpiresIn()
     * @uses OAuthRefreshResponse::setRefreshToken()
     * @param string $accessToken
     * @param string $tokenType
     * @param int $expiresIn
     * @param string $refreshToken
     */
    public function __construct($accessToken = null, $tokenType = null, $expiresIn = null, $refreshToken = null)
    {
        $this
            ->setAccessToken($accessToken)
            ->setTokenType($tokenType)
            ->setExpiresIn($expiresIn)
            ->setRefreshToken($refreshToken);
    }
    /**
     * Get accessToken value
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }
    /**
     * Set accessToken value
     * @param string $accessToken
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessToken)), __LINE__);
        }
        $this->accessToken = $accessToken;
        return $this;
    }
    /**
     * Get tokenType value
     * @return string|null
     */
    public function getTokenType()
    {
        return $this->tokenType;
    }
    /**
     * Set tokenType value
     * @param string $tokenType
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse
     */
    public function setTokenType($tokenType = null)
    {
        // validation for constraint: string
        if (!is_null($tokenType) && !is_string($tokenType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tokenType)), __LINE__);
        }
        $this->tokenType = $tokenType;
        return $this;
    }
    /**
     * Get expiresIn value
     * @return int|null
     */
    public function getExpiresIn()
    {
        return $this->expiresIn;
    }
    /**
     * Set expiresIn value
     * @param int $expiresIn
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse
     */
    public function setExpiresIn($expiresIn = null)
    {
        // validation for constraint: int
        if (!is_null($expiresIn) && !is_numeric($expiresIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expiresIn)), __LINE__);
        }
        $this->expiresIn = $expiresIn;
        return $this;
    }
    /**
     * Get refreshToken value
     * @return string|null
     */
    public function getRefreshToken()
    {
        return $this->refreshToken;
    }
    /**
     * Set refreshToken value
     * @param string $refreshToken
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse
     */
    public function setRefreshToken($refreshToken = null)
    {
        // validation for constraint: string
        if (!is_null($refreshToken) && !is_string($refreshToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refreshToken)), __LINE__);
        }
        $this->refreshToken = $refreshToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
