<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notificationTarget StructType
 * @subpackage Structs
 */
class NotificationTarget extends AbstractStructBase
{
    /**
     * The groupCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $groupCode;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * The feedsGroupRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $feedsGroupRef;
    /**
     * The feedType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $feedType;
    /**
     * The feedItemRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $feedItemRef;
    /**
     * Constructor method for notificationTarget
     * @uses NotificationTarget::setGroupCode()
     * @uses NotificationTarget::setEmailAddress()
     * @uses NotificationTarget::setFeedsGroupRef()
     * @uses NotificationTarget::setFeedType()
     * @uses NotificationTarget::setFeedItemRef()
     * @param int $groupCode
     * @param string $emailAddress
     * @param string $feedsGroupRef
     * @param string $feedType
     * @param string[] $feedItemRef
     */
    public function __construct($groupCode = null, $emailAddress = null, $feedsGroupRef = null, $feedType = null, array $feedItemRef = array())
    {
        $this
            ->setGroupCode($groupCode)
            ->setEmailAddress($emailAddress)
            ->setFeedsGroupRef($feedsGroupRef)
            ->setFeedType($feedType)
            ->setFeedItemRef($feedItemRef);
    }
    /**
     * Get groupCode value
     * @return int|null
     */
    public function getGroupCode()
    {
        return $this->groupCode;
    }
    /**
     * Set groupCode value
     * @param int $groupCode
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: int
        if (!is_null($groupCode) && !is_numeric($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->groupCode = $groupCode;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get feedsGroupRef value
     * @return string|null
     */
    public function getFeedsGroupRef()
    {
        return $this->feedsGroupRef;
    }
    /**
     * Set feedsGroupRef value
     * @param string $feedsGroupRef
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function setFeedsGroupRef($feedsGroupRef = null)
    {
        // validation for constraint: string
        if (!is_null($feedsGroupRef) && !is_string($feedsGroupRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedsGroupRef)), __LINE__);
        }
        $this->feedsGroupRef = $feedsGroupRef;
        return $this;
    }
    /**
     * Get feedType value
     * @return string|null
     */
    public function getFeedType()
    {
        return $this->feedType;
    }
    /**
     * Set feedType value
     * @param string $feedType
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function setFeedType($feedType = null)
    {
        // validation for constraint: string
        if (!is_null($feedType) && !is_string($feedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedType)), __LINE__);
        }
        $this->feedType = $feedType;
        return $this;
    }
    /**
     * Get feedItemRef value
     * @return string[]|null
     */
    public function getFeedItemRef()
    {
        return $this->feedItemRef;
    }
    /**
     * Set feedItemRef value
     * @throws \InvalidArgumentException
     * @param string[] $feedItemRef
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function setFeedItemRef(array $feedItemRef = array())
    {
        foreach ($feedItemRef as $notificationTargetFeedItemRefItem) {
            // validation for constraint: itemType
            if (!is_string($notificationTargetFeedItemRefItem)) {
                throw new \InvalidArgumentException(sprintf('The feedItemRef property can only contain items of string, "%s" given', is_object($notificationTargetFeedItemRefItem) ? get_class($notificationTargetFeedItemRefItem) : gettype($notificationTargetFeedItemRefItem)), __LINE__);
            }
        }
        $this->feedItemRef = $feedItemRef;
        return $this;
    }
    /**
     * Add item to feedItemRef value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public function addToFeedItemRef($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The feedItemRef property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->feedItemRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\NotificationTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
