<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for javascriptUrls StructType
 * @subpackage Structs
 */
class JavascriptUrls extends AbstractStructBase
{
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $url;
    /**
     * Constructor method for javascriptUrls
     * @uses JavascriptUrls::setUrl()
     * @param string[] $url
     */
    public function __construct(array $url = array())
    {
        $this
            ->setUrl($url);
    }
    /**
     * Get url value
     * @return string[]|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @throws \InvalidArgumentException
     * @param string[] $url
     * @return \QCC\CampusM\CloudService\StructType\JavascriptUrls
     */
    public function setUrl(array $url = array())
    {
        foreach ($url as $javascriptUrlsUrlItem) {
            // validation for constraint: itemType
            if (!is_string($javascriptUrlsUrlItem)) {
                throw new \InvalidArgumentException(sprintf('The url property can only contain items of string, "%s" given', is_object($javascriptUrlsUrlItem) ? get_class($javascriptUrlsUrlItem) : gettype($javascriptUrlsUrlItem)), __LINE__);
            }
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Add item to url value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\JavascriptUrls
     */
    public function addToUrl($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The url property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->url[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\JavascriptUrls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
