<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateHashRequest StructType
 * @subpackage Structs
 */
class GenerateHashRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The webappPassword
     * @var string
     */
    public $webappPassword;
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * Constructor method for generateHashRequest
     * @uses GenerateHashRequest::setOrgCode()
     * @uses GenerateHashRequest::setOrgMobilePassword()
     * @uses GenerateHashRequest::setWebappPassword()
     * @uses GenerateHashRequest::setUsername()
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param string $webappPassword
     * @param string $username
     */
    public function __construct($orgCode = null, $orgMobilePassword = null, $webappPassword = null, $username = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setWebappPassword($webappPassword)
            ->setUsername($username);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\GenerateHashRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\GenerateHashRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get webappPassword value
     * @return string|null
     */
    public function getWebappPassword()
    {
        return $this->webappPassword;
    }
    /**
     * Set webappPassword value
     * @param string $webappPassword
     * @return \QCC\CampusM\CloudService\StructType\GenerateHashRequest
     */
    public function setWebappPassword($webappPassword = null)
    {
        // validation for constraint: string
        if (!is_null($webappPassword) && !is_string($webappPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webappPassword)), __LINE__);
        }
        $this->webappPassword = $webappPassword;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \QCC\CampusM\CloudService\StructType\GenerateHashRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\GenerateHashRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
