<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for forgottenPasswordRequest StructType
 * @subpackage Structs
 */
class ForgottenPasswordRequest extends AbstractStructBase
{
    /**
     * The personId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The roleCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $roleCode;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailAddress;
    /**
     * Constructor method for forgottenPasswordRequest
     * @uses ForgottenPasswordRequest::setPersonId()
     * @uses ForgottenPasswordRequest::setOrgCode()
     * @uses ForgottenPasswordRequest::setOrgMobilePassword()
     * @uses ForgottenPasswordRequest::setRoleCode()
     * @uses ForgottenPasswordRequest::setEmailAddress()
     * @param int $personId
     * @param int $orgCode
     * @param string $orgMobilePassword
     * @param int $roleCode
     * @param string $emailAddress
     */
    public function __construct($personId = null, $orgCode = null, $orgMobilePassword = null, $roleCode = null, $emailAddress = null)
    {
        $this
            ->setPersonId($personId)
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setRoleCode($roleCode)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get roleCode value
     * @return int|null
     */
    public function getRoleCode()
    {
        return $this->roleCode;
    }
    /**
     * Set roleCode value
     * @param int $roleCode
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public function setRoleCode($roleCode = null)
    {
        // validation for constraint: int
        if (!is_null($roleCode) && !is_numeric($roleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roleCode)), __LINE__);
        }
        $this->roleCode = $roleCode;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
