<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for detail StructType
 * @subpackage Structs
 */
class Detail extends AbstractStructBase
{
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The job
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $job;
    /**
     * The dept
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dept;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The optIn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $optIn;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $profileId;
    /**
     * Constructor method for detail
     * @uses Detail::setFirstName()
     * @uses Detail::setLastName()
     * @uses Detail::setEmail()
     * @uses Detail::setOrganisation()
     * @uses Detail::setJob()
     * @uses Detail::setDept()
     * @uses Detail::setAddress()
     * @uses Detail::setCountry()
     * @uses Detail::setOptIn()
     * @uses Detail::setProfileId()
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param string $organisation
     * @param string $job
     * @param string $dept
     * @param string $address
     * @param string $country
     * @param string $optIn
     * @param int $profileId
     */
    public function __construct($firstName = null, $lastName = null, $email = null, $organisation = null, $job = null, $dept = null, $address = null, $country = null, $optIn = null, $profileId = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setOrganisation($organisation)
            ->setJob($job)
            ->setDept($dept)
            ->setAddress($address)
            ->setCountry($country)
            ->setOptIn($optIn)
            ->setProfileId($profileId);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get job value
     * @return string|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param string $job
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setJob($job = null)
    {
        // validation for constraint: string
        if (!is_null($job) && !is_string($job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($job)), __LINE__);
        }
        $this->job = $job;
        return $this;
    }
    /**
     * Get dept value
     * @return string|null
     */
    public function getDept()
    {
        return $this->dept;
    }
    /**
     * Set dept value
     * @param string $dept
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setDept($dept = null)
    {
        // validation for constraint: string
        if (!is_null($dept) && !is_string($dept)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dept)), __LINE__);
        }
        $this->dept = $dept;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get optIn value
     * @return string|null
     */
    public function getOptIn()
    {
        return $this->optIn;
    }
    /**
     * Set optIn value
     * @param string $optIn
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setOptIn($optIn = null)
    {
        // validation for constraint: string
        if (!is_null($optIn) && !is_string($optIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optIn)), __LINE__);
        }
        $this->optIn = $optIn;
        return $this;
    }
    /**
     * Get profileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->profileId) ? $this->profileId : null;
    }
    /**
     * Set profileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->profileId);
        } else {
            $this->profileId = $profileId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Detail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
