<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for delegateDetailsRequest StructType
 * @subpackage Structs
 */
class DelegateDetailsRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The uid
     * @var int
     */
    public $uid;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $profileId;
    /**
     * Constructor method for delegateDetailsRequest
     * @uses DelegateDetailsRequest::setOrgCode()
     * @uses DelegateDetailsRequest::setUid()
     * @uses DelegateDetailsRequest::setPersonId()
     * @uses DelegateDetailsRequest::setPassword()
     * @uses DelegateDetailsRequest::setProfileId()
     * @param int $orgCode
     * @param int $uid
     * @param int $personId
     * @param string $password
     * @param int $profileId
     */
    public function __construct($orgCode = null, $uid = null, $personId = null, $password = null, $profileId = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setUid($uid)
            ->setPersonId($personId)
            ->setPassword($password)
            ->setProfileId($profileId);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get uid value
     * @return int|null
     */
    public function getUid()
    {
        return $this->uid;
    }
    /**
     * Set uid value
     * @param int $uid
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public function setUid($uid = null)
    {
        // validation for constraint: int
        if (!is_null($uid) && !is_numeric($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uid)), __LINE__);
        }
        $this->uid = $uid;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get profileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->profileId) ? $this->profileId : null;
    }
    /**
     * Set profileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->profileId);
        } else {
            $this->profileId = $profileId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
