<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certificateStatus StructType
 * @subpackage Structs
 */
class CertificateStatus extends AbstractStructBase
{
    /**
     * The certificate
     * @var string
     */
    public $certificate;
    /**
     * The expires
     * @var string
     */
    public $expires;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The orgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $orgCode;
    /**
     * Constructor method for certificateStatus
     * @uses CertificateStatus::setCertificate()
     * @uses CertificateStatus::setExpires()
     * @uses CertificateStatus::setStatus()
     * @uses CertificateStatus::setOrgCode()
     * @param string $certificate
     * @param string $expires
     * @param string $status
     * @param int $orgCode
     */
    public function __construct($certificate = null, $expires = null, $status = null, $orgCode = null)
    {
        $this
            ->setCertificate($certificate)
            ->setExpires($expires)
            ->setStatus($status)
            ->setOrgCode($orgCode);
    }
    /**
     * Get certificate value
     * @return string|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
    /**
     * Set certificate value
     * @param string $certificate
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatus
     */
    public function setCertificate($certificate = null)
    {
        // validation for constraint: string
        if (!is_null($certificate) && !is_string($certificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificate)), __LINE__);
        }
        $this->certificate = $certificate;
        return $this;
    }
    /**
     * Get expires value
     * @return string|null
     */
    public function getExpires()
    {
        return $this->expires;
    }
    /**
     * Set expires value
     * @param string $expires
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatus
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expires)), __LINE__);
        }
        $this->expires = $expires;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get orgCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrgCode()
    {
        return isset($this->orgCode) ? $this->orgCode : null;
    }
    /**
     * Set orgCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatus
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        if (is_null($orgCode) || (is_array($orgCode) && empty($orgCode))) {
            unset($this->orgCode);
        } else {
            $this->orgCode = $orgCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
