<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for category StructType
 * @subpackage Structs
 */
class Category extends AbstractStructBase
{
    /**
     * The vcCode
     * @var int
     */
    public $vcCode;
    /**
     * The vcImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vcImage;
    /**
     * The desc
     * @var string
     */
    public $desc;
    /**
     * The order
     * @var int
     */
    public $order;
    /**
     * Constructor method for category
     * @uses Category::setVcCode()
     * @uses Category::setVcImage()
     * @uses Category::setDesc()
     * @uses Category::setOrder()
     * @param int $vcCode
     * @param string $vcImage
     * @param string $desc
     * @param int $order
     */
    public function __construct($vcCode = null, $vcImage = null, $desc = null, $order = null)
    {
        $this
            ->setVcCode($vcCode)
            ->setVcImage($vcImage)
            ->setDesc($desc)
            ->setOrder($order);
    }
    /**
     * Get vcCode value
     * @return int|null
     */
    public function getVcCode()
    {
        return $this->vcCode;
    }
    /**
     * Set vcCode value
     * @param int $vcCode
     * @return \QCC\CampusM\CloudService\StructType\Category
     */
    public function setVcCode($vcCode = null)
    {
        // validation for constraint: int
        if (!is_null($vcCode) && !is_numeric($vcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vcCode)), __LINE__);
        }
        $this->vcCode = $vcCode;
        return $this;
    }
    /**
     * Get vcImage value
     * @return string|null
     */
    public function getVcImage()
    {
        return $this->vcImage;
    }
    /**
     * Set vcImage value
     * @param string $vcImage
     * @return \QCC\CampusM\CloudService\StructType\Category
     */
    public function setVcImage($vcImage = null)
    {
        // validation for constraint: string
        if (!is_null($vcImage) && !is_string($vcImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vcImage)), __LINE__);
        }
        $this->vcImage = $vcImage;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \QCC\CampusM\CloudService\StructType\Category
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\Category
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Category
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
