<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookmarks StructType
 * @subpackage Structs
 */
class Bookmarks extends AbstractStructBase
{
    /**
     * The bookmark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Bookmark[]
     */
    public $bookmark;
    /**
     * Constructor method for bookmarks
     * @uses Bookmarks::setBookmark()
     * @param \QCC\CampusM\CloudService\StructType\Bookmark[] $bookmark
     */
    public function __construct(array $bookmark = array())
    {
        $this
            ->setBookmark($bookmark);
    }
    /**
     * Get bookmark value
     * @return \QCC\CampusM\CloudService\StructType\Bookmark[]|null
     */
    public function getBookmark()
    {
        return $this->bookmark;
    }
    /**
     * Set bookmark value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Bookmark[] $bookmark
     * @return \QCC\CampusM\CloudService\StructType\Bookmarks
     */
    public function setBookmark(array $bookmark = array())
    {
        foreach ($bookmark as $bookmarksBookmarkItem) {
            // validation for constraint: itemType
            if (!$bookmarksBookmarkItem instanceof \QCC\CampusM\CloudService\StructType\Bookmark) {
                throw new \InvalidArgumentException(sprintf('The bookmark property can only contain items of \QCC\CampusM\CloudService\StructType\Bookmark, "%s" given', is_object($bookmarksBookmarkItem) ? get_class($bookmarksBookmarkItem) : gettype($bookmarksBookmarkItem)), __LINE__);
            }
        }
        $this->bookmark = $bookmark;
        return $this;
    }
    /**
     * Add item to bookmark value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Bookmark $item
     * @return \QCC\CampusM\CloudService\StructType\Bookmarks
     */
    public function addToBookmark(\QCC\CampusM\CloudService\StructType\Bookmark $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Bookmark) {
            throw new \InvalidArgumentException(sprintf('The bookmark property can only contain items of \QCC\CampusM\CloudService\StructType\Bookmark, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bookmark[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Bookmarks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
