<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookmarkUserRequest StructType
 * @subpackage Structs
 */
class BookmarkUserRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The pgCode
     * @var int
     */
    public $pgCode;
    /**
     * The sortCode
     * @var int
     */
    public $sortCode;
    /**
     * Constructor method for bookmarkUserRequest
     * @uses BookmarkUserRequest::setPersonId()
     * @uses BookmarkUserRequest::setPgCode()
     * @uses BookmarkUserRequest::setSortCode()
     * @param int $personId
     * @param int $pgCode
     * @param int $sortCode
     */
    public function __construct($personId = null, $pgCode = null, $sortCode = null)
    {
        $this
            ->setPersonId($personId)
            ->setPgCode($pgCode)
            ->setSortCode($sortCode);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\BookmarkUserRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get pgCode value
     * @return int|null
     */
    public function getPgCode()
    {
        return $this->pgCode;
    }
    /**
     * Set pgCode value
     * @param int $pgCode
     * @return \QCC\CampusM\CloudService\StructType\BookmarkUserRequest
     */
    public function setPgCode($pgCode = null)
    {
        // validation for constraint: int
        if (!is_null($pgCode) && !is_numeric($pgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pgCode)), __LINE__);
        }
        $this->pgCode = $pgCode;
        return $this;
    }
    /**
     * Get sortCode value
     * @return int|null
     */
    public function getSortCode()
    {
        return $this->sortCode;
    }
    /**
     * Set sortCode value
     * @param int $sortCode
     * @return \QCC\CampusM\CloudService\StructType\BookmarkUserRequest
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: int
        if (!is_null($sortCode) && !is_numeric($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortCode)), __LINE__);
        }
        $this->sortCode = $sortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\BookmarkUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
