<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for advert StructType
 * @subpackage Structs
 */
class Advert extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The advertCode
     * @var int
     */
    public $advertCode;
    /**
     * The order
     * @var int
     */
    public $order;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The advertURL
     * @var string
     */
    public $advertURL;
    /**
     * The imageURL
     * @var string
     */
    public $imageURL;
    /**
     * The pocketGuide
     * @var string
     */
    public $pocketGuide;
    /**
     * The displayDuration
     * @var int
     */
    public $displayDuration;
    /**
     * The menuRefCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $menuRefCode;
    /**
     * The menuCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $menuCode;
    /**
     * The pgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pgCode;
    /**
     * Constructor method for advert
     * @uses Advert::setOrgCode()
     * @uses Advert::setAdvertCode()
     * @uses Advert::setOrder()
     * @uses Advert::setDescription()
     * @uses Advert::setAdvertURL()
     * @uses Advert::setImageURL()
     * @uses Advert::setPocketGuide()
     * @uses Advert::setDisplayDuration()
     * @uses Advert::setMenuRefCode()
     * @uses Advert::setMenuCode()
     * @uses Advert::setPgCode()
     * @param int $orgCode
     * @param int $advertCode
     * @param int $order
     * @param string $description
     * @param string $advertURL
     * @param string $imageURL
     * @param string $pocketGuide
     * @param int $displayDuration
     * @param string $menuRefCode
     * @param string $menuCode
     * @param int $pgCode
     */
    public function __construct($orgCode = null, $advertCode = null, $order = null, $description = null, $advertURL = null, $imageURL = null, $pocketGuide = null, $displayDuration = null, $menuRefCode = null, $menuCode = null, $pgCode = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setAdvertCode($advertCode)
            ->setOrder($order)
            ->setDescription($description)
            ->setAdvertURL($advertURL)
            ->setImageURL($imageURL)
            ->setPocketGuide($pocketGuide)
            ->setDisplayDuration($displayDuration)
            ->setMenuRefCode($menuRefCode)
            ->setMenuCode($menuCode)
            ->setPgCode($pgCode);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get advertCode value
     * @return int|null
     */
    public function getAdvertCode()
    {
        return $this->advertCode;
    }
    /**
     * Set advertCode value
     * @param int $advertCode
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setAdvertCode($advertCode = null)
    {
        // validation for constraint: int
        if (!is_null($advertCode) && !is_numeric($advertCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($advertCode)), __LINE__);
        }
        $this->advertCode = $advertCode;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertURL value
     * @return string|null
     */
    public function getAdvertURL()
    {
        return $this->advertURL;
    }
    /**
     * Set advertURL value
     * @param string $advertURL
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setAdvertURL($advertURL = null)
    {
        // validation for constraint: string
        if (!is_null($advertURL) && !is_string($advertURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertURL)), __LINE__);
        }
        $this->advertURL = $advertURL;
        return $this;
    }
    /**
     * Get imageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->imageURL;
    }
    /**
     * Set imageURL value
     * @param string $imageURL
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->imageURL = $imageURL;
        return $this;
    }
    /**
     * Get pocketGuide value
     * @return string|null
     */
    public function getPocketGuide()
    {
        return $this->pocketGuide;
    }
    /**
     * Set pocketGuide value
     * @param string $pocketGuide
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setPocketGuide($pocketGuide = null)
    {
        // validation for constraint: string
        if (!is_null($pocketGuide) && !is_string($pocketGuide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pocketGuide)), __LINE__);
        }
        $this->pocketGuide = $pocketGuide;
        return $this;
    }
    /**
     * Get displayDuration value
     * @return int|null
     */
    public function getDisplayDuration()
    {
        return $this->displayDuration;
    }
    /**
     * Set displayDuration value
     * @param int $displayDuration
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setDisplayDuration($displayDuration = null)
    {
        // validation for constraint: int
        if (!is_null($displayDuration) && !is_numeric($displayDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayDuration)), __LINE__);
        }
        $this->displayDuration = $displayDuration;
        return $this;
    }
    /**
     * Get menuRefCode value
     * @return string|null
     */
    public function getMenuRefCode()
    {
        return $this->menuRefCode;
    }
    /**
     * Set menuRefCode value
     * @param string $menuRefCode
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setMenuRefCode($menuRefCode = null)
    {
        // validation for constraint: string
        if (!is_null($menuRefCode) && !is_string($menuRefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuRefCode)), __LINE__);
        }
        $this->menuRefCode = $menuRefCode;
        return $this;
    }
    /**
     * Get menuCode value
     * @return string|null
     */
    public function getMenuCode()
    {
        return $this->menuCode;
    }
    /**
     * Set menuCode value
     * @param string $menuCode
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setMenuCode($menuCode = null)
    {
        // validation for constraint: string
        if (!is_null($menuCode) && !is_string($menuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuCode)), __LINE__);
        }
        $this->menuCode = $menuCode;
        return $this;
    }
    /**
     * Get pgCode value
     * @return int|null
     */
    public function getPgCode()
    {
        return $this->pgCode;
    }
    /**
     * Set pgCode value
     * @param int $pgCode
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public function setPgCode($pgCode = null)
    {
        // validation for constraint: int
        if (!is_null($pgCode) && !is_numeric($pgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pgCode)), __LINE__);
        }
        $this->pgCode = $pgCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Advert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
