<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named userDetailService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UserDetailRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UserDetailResponse|bool
     */
    public function userDetailService(\QCC\CampusM\CloudService\StructType\UserDetailRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->userDetailService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UserLoginRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UserLoginResponse|bool
     */
    public function userLogin(\QCC\CampusM\CloudService\StructType\UserLoginRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->userLogin($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userLoginLDAP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse|bool
     */
    public function userLoginLDAP(\QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->userLoginLDAP($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userLoginOAuth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse|bool
     */
    public function userLoginOAuth(\QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->userLoginOAuth($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\UserDetailResponse|\QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse|\QCC\CampusM\CloudService\StructType\UserLoginOAuthResponse|\QCC\CampusM\CloudService\StructType\UserLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
