<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Setup ServiceType
 * @subpackage Services
 */
class Setup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setupUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SetupUserRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SetupUserResponse|bool
     */
    public function setupUser(\QCC\CampusM\CloudService\StructType\SetupUserRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->setupUser($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setupCouncilAlerts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SetupCouncilAlertsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function setupCouncilAlerts(\QCC\CampusM\CloudService\StructType\SetupCouncilAlertsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->setupCouncilAlerts($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|\QCC\CampusM\CloudService\StructType\SetupUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
