<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchJobVacanciesService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SearchJobVacancies $payload
     * @return \QCC\CampusM\CloudService\StructType\SearchJobVacanciesResponse|bool
     */
    public function searchJobVacanciesService(\QCC\CampusM\CloudService\StructType\SearchJobVacancies $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->searchJobVacanciesService($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchDirectoryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SearchDirectoryListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SearchDirectoryListResponse|bool
     */
    public function searchDirectoryList(\QCC\CampusM\CloudService\StructType\SearchDirectoryListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->searchDirectoryList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchDirList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SearchDirListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SearchDirListResponse|bool
     */
    public function searchDirList(\QCC\CampusM\CloudService\StructType\SearchDirListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->searchDirList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchPosition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SearchPositionRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SearchPositionResponse|bool
     */
    public function searchPosition(\QCC\CampusM\CloudService\StructType\SearchPositionRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->searchPosition($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchPerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\SearchPersonRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\SearchPersonResponse|bool
     */
    public function searchPerson(\QCC\CampusM\CloudService\StructType\SearchPersonRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->searchPerson($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\SearchDirectoryListResponse|\QCC\CampusM\CloudService\StructType\SearchDirListResponse|\QCC\CampusM\CloudService\StructType\SearchJobVacanciesResponse|\QCC\CampusM\CloudService\StructType\SearchPersonResponse|\QCC\CampusM\CloudService\StructType\SearchPositionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
