<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reg ServiceType
 * @subpackage Services
 */
class Reg extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named regProcess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\RegProcessRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\RegProcessResponse|bool
     */
    public function regProcess(\QCC\CampusM\CloudService\StructType\RegProcessRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->regProcess($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\RegProcessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
