<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pocket ServiceType
 * @subpackage Services
 */
class Pocket extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pocketGuideContent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\PocketGuideContentRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\PocketGuideContentResponse|bool
     */
    public function pocketGuideContent(\QCC\CampusM\CloudService\StructType\PocketGuideContentRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->pocketGuideContent($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pocketGuide
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\PocketGuide $payload
     * @return \QCC\CampusM\CloudService\StructType\PocketGuideResponse|bool
     */
    public function pocketGuide(\QCC\CampusM\CloudService\StructType\PocketGuide $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->pocketGuide($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\PocketGuideContentResponse|\QCC\CampusM\CloudService\StructType\PocketGuideResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
