<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Org ServiceType
 * @subpackage Services
 */
class Org extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named orgUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\OrgUsersRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\OrgUsersResponse|bool
     */
    public function orgUsers(\QCC\CampusM\CloudService\StructType\OrgUsersRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->orgUsers($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\OrgUsersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
