<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Location ServiceType
 * @subpackage Services
 */
class Location extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named locationCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesResponse|bool
     */
    public function locationCategories(\QCC\CampusM\CloudService\StructType\LocationCategoriesRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->locationCategories($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named locationList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\LocationListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\LocationListResponse|bool
     */
    public function locationList(\QCC\CampusM\CloudService\StructType\LocationListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->locationList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesResponse|\QCC\CampusM\CloudService\StructType\LocationListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
