<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Facebook ServiceType
 * @subpackage Services
 */
class Facebook extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named facebookPostAuthorize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\FacebookPostAuthorizeRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function facebookPostAuthorize(\QCC\CampusM\CloudService\StructType\FacebookPostAuthorizeRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->facebookPostAuthorize($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named facebookPostRemove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\FacebookPostRemoveRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function facebookPostRemove(\QCC\CampusM\CloudService\StructType\FacebookPostRemoveRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->facebookPostRemove($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
