<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkInLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CheckInLocationsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\CheckInLocationsResponse|bool
     */
    public function checkInLocations(\QCC\CampusM\CloudService\StructType\CheckInLocationsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->checkInLocations($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkActivatedEmails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CheckActivatedEmailsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\CheckActivatedEmailsResponse|bool
     */
    public function checkActivatedEmails(\QCC\CampusM\CloudService\StructType\CheckActivatedEmailsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->checkActivatedEmails($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\CheckActivatedEmailsResponse|\QCC\CampusM\CloudService\StructType\CheckInLocationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
