<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Certificate ServiceType
 * @subpackage Services
 */
class Certificate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named certificateStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CertificateStatusRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatusResponse|bool
     */
    public function certificateStatus(\QCC\CampusM\CloudService\StructType\CertificateStatusRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->certificateStatus($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\CertificateStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
