<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Appropriate ServiceType
 * @subpackage Services
 */
class Appropriate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appropriate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\Appropriate $payload
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus|bool
     */
    public function appropriate(\QCC\CampusM\CloudService\StructType\Appropriate $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->appropriate($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReturnStatus
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
