<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for App ServiceType
 * @subpackage Services
 */
class App extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\AppUsersRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\AppUsersResponse|bool
     */
    public function appUsers(\QCC\CampusM\CloudService\StructType\AppUsersRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->appUsers($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appDirectoryLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginResponse|bool
     */
    public function appDirectoryLogin(\QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->appDirectoryLogin($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\AppDirectoryLoginResponse|\QCC\CampusM\CloudService\StructType\AppUsersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
