<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Aek ServiceType
 * @subpackage Services
 */
class Aek extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named aekPage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\AekPageRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\AekPageResponse|bool
     */
    public function aekPage(\QCC\CampusM\CloudService\StructType\AekPageRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->aekPage($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\AekPageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
